package com.system.utils;

import com.system.constants.Constants;
import com.system.dao.ThirdPartyLogMapper;
import com.system.transfer.log.ThirdPartyLogCreateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author Inori
 */
@Component
public class ThirdPartyLogUtil {

    @Autowired
    private ThirdPartyLogMapper thirdPartyLogMapper;


    public Integer isExist(String queueId) {
        return thirdPartyLogMapper.getThirdPartyLogByQueueId(queueId);
    }

    public void thirdPartyLogCreate(String name, String docType, String queueId, String direction, String request, String response) {
        ThirdPartyLogCreateInVo inVo = new ThirdPartyLogCreateInVo();
        inVo.setName(name);
        inVo.setCode(docType);
        inVo.setQueueId(queueId);
        inVo.setDirection(direction);
        inVo.setRequest(request);
        inVo.setResponse(response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            inVo.setFlag(1);
        } else {
            inVo.setFlag(0);
        }

        thirdPartyLogMapper.thirdPartyLogCreate(inVo);
    }

    public void thirdPartyLogCreate(String name, String docType, String queueId, String direction, String request, String response, Integer flag) {
        ThirdPartyLogCreateInVo inVo = new ThirdPartyLogCreateInVo();
        inVo.setName(name);
        inVo.setCode(docType);
        inVo.setQueueId(queueId);
        inVo.setDirection(direction);
        inVo.setRequest(request);
        inVo.setResponse(response);
        inVo.setFlag(flag);

        thirdPartyLogMapper.thirdPartyLogCreate(inVo);
    }


}
