package com.system.api;

import com.system.config.ThreadLocalConfig;
import com.system.constants.Constants;
import com.system.constants.MallConstants;
import com.system.exception.MallCommonException;
import com.system.serializer.SerializerProxy;
import com.system.transfer.form.MallFieldMappingListOutVoRecords;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.ProductLogUtil;
import com.system.utils.SnowFlakeIdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author Inori
 */
@Component
public class CommonApi {

    private final String serviceNameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";

    public boolean flag = false;

    private static final String LOGIN_MESSAGE = "金蝶服务器连接异常";

    /**
     * 后缀
     */
    private static final String HTTP_SUFFIX = ".common.kdsvc";

    /**
     * Cookie
     */
    private String cookieStore;

    private String serverUrl;

    @Autowired
    private ProductLogUtil productLogUtil;

    public static String encapsulationData(Map<String, String> config, List<Map<String, Object>> dataList, List<MallFieldMappingListOutVoRecords> fieldList) {
        if (Integer.parseInt(config.get(Constants.ENCAPSULATION_FORMAT)) == 1) {
            return encapsulationDataOnWhole(SnowFlakeIdUtil.generateId().toString(), dataList, fieldList);
        } else {
            return encapsulationDataOnPolymerization(SnowFlakeIdUtil.generateId().toString(), config.get("entryName"), dataList, fieldList);
        }
    }

    private static String encapsulationDataOnWhole(String queueId, List<Map<String, Object>> dataList, List<MallFieldMappingListOutVoRecords> fieldList) {
        List<Map<String, Object>> request = new ArrayList<>();
        for (Map<String, Object> data : dataList) {
            Map<String, Object> temp = new LinkedHashMap<>();
            temp.put("QUEUE_ID", queueId);
            for (MallFieldMappingListOutVoRecords records : fieldList) {
                encapsulationFieldData(data, temp, records);
            }
            request.add(temp);
        }
        return JsonUtil.toString(request);
    }

    private static String encapsulationDataOnPolymerization(String queueId, String entryName, List<Map<String, Object>> dataList, List<MallFieldMappingListOutVoRecords> fieldList) {
        Map<String, Object> request = new LinkedHashMap<>(2);
        List<Map<String, Object>> tempList = new ArrayList<>();
        for (Map<String, Object> data : dataList) {
            request.put("QUEUE_ID", queueId);

            Map<String, Object> temp = new LinkedHashMap<>();
            for (MallFieldMappingListOutVoRecords records : fieldList) {
                if (Constants.SUCCESS_CODE.equals(records.getIsEntryField())) {
                    encapsulationFieldData(data, temp, records);
                } else {
                    encapsulationFieldData(data, request, records);
                }
            }
            if (!CollectionUtils.isEmpty(temp)) {
                tempList.add(temp);
            }
        }

        if (!CollectionUtils.isEmpty(tempList)) {
            request.put(entryName, tempList);
        }
        return JsonUtil.toString(request);
    }

    private static void encapsulationFieldData(Map<String, Object> temp, Map<String, Object> data, MallFieldMappingListOutVoRecords records) {
        String fieldType = records.getFieldType();
        String fieldBeforeMapping = records.getFieldBeforeMapping();
        String fieldAfterMapping = records.getFieldAfterMapping();
        if (Constants.INT_NAME.equals(fieldType)) {
            try {
                data.put(fieldAfterMapping, Integer.valueOf(String.valueOf(temp.get(fieldBeforeMapping))));
            } catch (NumberFormatException e) {
                data.put(fieldAfterMapping, temp.get(fieldBeforeMapping));
            }
        } else if (Constants.BIG_DECIMAL_NAME.equals(fieldType)) {
            try {
                data.put(fieldAfterMapping, new BigDecimal(String.valueOf(temp.get(fieldBeforeMapping))));
            } catch (NumberFormatException e) {
                data.put(fieldAfterMapping, temp.get(fieldBeforeMapping));
            }
        } else {
            data.put(fieldAfterMapping, temp.get(fieldBeforeMapping));
        }
    }

    /**
     * 查询 SQL
     */
    public String mallSelectBySql(Map<String, String> config, String queueId, String request) {
        return mallSql(config, queueId, request, serviceNameMap);
    }

    private String mallSql(Map<String, String> config, String queueId, String request, String serviceName) {
        try {
            if (this.flag) {
                String response = this.execute(serviceName, new Object[]{request}, String.class);

                //记录SQL查询金蝶数据的请求及响应信息
                productLogUtil.productSqlLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), JsonUtil.toString(request), response);

                return response;
            } else {
                throw new MallCommonException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
            throw new MallCommonException(LOGIN_MESSAGE);
        }
    }

    public <T> T execute(String serviceName, Object[] parameters, Class<T> returnType) throws Exception {
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookieStore);

        Map<String, Object> request = new HashMap<>(1);
        request.put("parameters", parameters);

        String url = serverUrl + serviceName + HTTP_SUFFIX;
        System.out.println("------------>" + url);

        long start = System.currentTimeMillis();
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, JsonUtil.toString(request));
        long costTime = System.currentTimeMillis() - start;

        Map<String, Object> map = ThreadLocalConfig.get();
        map.put("costTime", costTime);
        ThreadLocalConfig.set(map);

        return (T) (new SerializerProxy()).deserialize(responseEntity.getBody(), returnType);
    }

    public String sendPlugInUnit(String plugInUrl, String json, Integer index) {
        try {
            return HttpUtil.httpPost(plugInUrl, json).getBody();
        } catch (Exception e) {
            if (index != 0) {
                this.sendPlugInUnit(plugInUrl, json, index - 1);
            }

            Map<String, Object> map = new HashMap<>(2);
            map.put("resultCode", MallConstants.ERROR_CODE);
            map.put("resultMsg", "插件请求超时");
            return JsonUtil.toString(map);
        }
    }


}
