package com.system.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.system.config.ThreadLocalConfig;
import com.system.constants.MallConstants;
import com.system.dao.InitConnectParamMapper;
import com.system.exception.MallCommonException;
import com.system.model.DelayedElement;
import com.system.model.InitConnectParam;
import com.system.serializer.SerializerProxy;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.ProductLogUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

/**
 * @author Inori
 */
@Component
public class CommonHttpApi {

    private ExecutorService threadPool = new ThreadPoolExecutor(10, 10,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<Runnable>(1024),
            new ThreadFactoryBuilder().setNameFormat("http-pool-%d").build(),
            new ThreadPoolExecutor.AbortPolicy());

    private static final String LOGIN_MESSAGE = "商城服务器连接异常";

    public InitConnectParam initConnectParam;

    public String mallAddress;

    public String receiveAddress;

    public Map<String, Object> header;

    public boolean flag = false;

    @Autowired
    private InitConnectParamMapper initConnectParamMapper;

    @Autowired
    private ProductLogUtil productLogUtil;


    @PostConstruct
    public void init() {
        initConnectParam = initConnectParamMapper.selectOne(new QueryWrapper<InitConnectParam>().last("LIMIT 1"));
        if (StringUtil.isNotNull(initConnectParam)) {
            mallAddress = initConnectParam.getMallAddress();
            receiveAddress = initConnectParam.getReceiveAddress();
        }
    }

    public InitConnectParam getInitConnectParam() {
        return initConnectParam;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    private String stringKey(Map<String, String> map) {
        StringBuilder keys = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(keys)) {
                keys.append(", ").append(entry.getKey());
            } else {
                keys = new StringBuilder(entry.getKey());
            }
        }
        if (StringUtil.isNotBlank(keys.toString())) {
            return keys.toString();
        }
        return "";
    }

    private String stringWhere(Map<String, Object> map) {
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(where)) {
                where.append(" AND ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
            } else {
                where = new StringBuilder(entry.getKey() + "='" + entry.getValue() + "'");
            }
        }
        if (StringUtil.isNotBlank(where.toString())) {
            return where.toString();
        }
        return "";
    }

    public String commonHttpSync(List<Integer> idList) {
        try {
            if (flag) {
                return HttpUtil.httpPost(mallAddress + "wx/api/dataSyn/getSyn", header, JsonUtil.toString(idList)).getBody();
            } else {
                throw new MallCommonException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new MallCommonException(LOGIN_MESSAGE);
        }
    }

    public String commonHttpPostByUpdate(String data) {
        try {
            if (flag) {
                return HttpUtil.httpPost(mallAddress + "wx/api/dataSyn/success", header, data).getBody();
            } else {
                throw new MallCommonException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new MallCommonException(LOGIN_MESSAGE);
        }
    }

    public String commonHttpSyncData(Map<String, String> config, String queueId, String name, List<String> keyList, Map<String, Object> where) {
        try {
            if (flag) {
                Map<String, Object> request = new HashMap<>(3);
                request.put("form", config.get("sFormId"));
                request.put("fields", String.join(",", keyList));
                request.putAll(where);
                System.out.println();
                System.out.println("request======="+request);
                System.out.println();
                long start = System.currentTimeMillis();
                String response = HttpUtil.httpPost(mallAddress + "wx/api/dataSyn/synData", header, JsonUtil.toString(request)).getBody();
                long costTime = System.currentTimeMillis() - start;

                Map<String, Object> map = ThreadLocalConfig.get();
                map.put("costTime", costTime);
                ThreadLocalConfig.set(map);

                productLogUtil.productSyncLogCreate(Integer.valueOf(config.get("productId")), queueId, name, config.get("docType"), config.get("direction"), JsonUtil.toString(request), response);
                return response;
            } else {
                throw new MallCommonException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new MallCommonException(LOGIN_MESSAGE);
        }
    }

    public String sendThirdParty(String data, int index) {
        try {
            System.out.println("data====="+ data);
            return HttpUtil.httpPost(this.receiveAddress, data).getBody();
        } catch (Exception e) {
            e.printStackTrace();
            if (index != 0) {
                this.sendThirdParty( data, index - 1);
            } else {
                //关闭同步
                HttpUtil.httpGet("http://integrate-system:8090/integrate/api/quartz/job/pause?jobClassName=com.system.quartz.job.MallSynchronizationJob");

                DelayQueue<DelayedElement> delayQueue = new DelayQueue<>();
                threadPool.execute(() -> {
                    //take方法将阻塞线程
                    delayQueue.add(new DelayedElement(60));

                    try {
                        delayQueue.take();
                    } catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }

                    //开启同步
                    HttpUtil.httpGet("http://integrate-system:8090/integrate/api/quartz/job/resume?jobClassName=com.system.quartz.job.MallSynchronizationJob");
                });
            }

            Map<String, Object> map = new HashMap<>(2);
            map.put("resultCode", MallConstants.OVERTIME_CODE);
            map.put("resultMsg", "第三方请求超时");
            return JsonUtil.toString(map);
        }
    }

}
