package com.system.constants;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.system.dao.MallCommonConfigMapper;
import com.system.transfer.form.MallCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Component
public class MallCommonSyncConstants {

    private Map<Integer, Map<String, Map<String, String>>> map = new ConcurrentHashMap<>();

    @Autowired
    private MallCommonConfigMapper mallCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<MallCommonConfigListOutVoRecords> recordsList = mallCommonConfigMapper.mallCommonConfigList(3);
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(MallCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<Map<String, Object>> fieldMappingList = mallCommonConfigMapper.mallFieldMappingList(idList);

            List<Integer> keyList = recordsList.stream().map(MallCommonConfigListOutVoRecords::getPlatformProductRelationId).distinct().collect(Collectors.toList());
            for (Integer key : keyList) {
                this.map.put(key, new ConcurrentHashMap<>(5));
                Map<String, Map<String, String>> config = this.map.get(key);

                List<MallCommonConfigListOutVoRecords> temp01List = recordsList.stream().filter(m -> key.equals(m.getPlatformProductRelationId())).collect(Collectors.toList());
                for (MallCommonConfigListOutVoRecords records : temp01List) {
                    List<Map<String, Object>> temp02List = fieldMappingList.stream().filter(m -> records.getId().equals(m.get("id"))).collect(Collectors.toList());
                    config.put(records.getSFormId(), this.encapsulationMallFieldConfig(records, temp02List));
                }
            }
        }
    }

    public List<Map<String, String>> get(String sFormId) {
        List<Map<String, String>> configList = new ArrayList<>();
        for (Map.Entry<Integer, Map<String, Map<String, String>>> entry : this.map.entrySet()) {
            Map<String, Map<String, String>> temp = entry.getValue();

            Map<String, String> result = temp.get(sFormId);
            if (!CollectionUtils.isEmpty(result)) {
                configList.add(result);
            }
        }
        return configList;
    }

    public void refresh(Integer id, String sFormId) {
        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(id);

        Map<String, Map<String, String>> temp = this.map.get(records.getPlatformProductRelationId());
        if (!CollectionUtils.isEmpty(temp)) {
            temp.remove(sFormId);
            List<Map<String, Object>> tempList = mallCommonConfigMapper.mallFieldMappingList(Stream.of(records.getId()).collect(Collectors.toList()));
            temp.put(records.getSFormId(), this.encapsulationMallFieldConfig(records, tempList));
        }
    }

    /**
     * 封装自定义表单配置
     */
    private Map<String, String> encapsulationMallFieldConfig(MallCommonConfigListOutVoRecords records, List<Map<String, Object>> tempList) {
        Map<String, String> temp = new HashMap<>(10);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("docType", records.getDocType());
        //商城标识
        temp.put("sFormId", records.getSFormId());
        temp.put("name", records.getName());
        //方向
        temp.put("direction", records.getDirection());
        //操作
        temp.put("operation", String.valueOf(records.getOperation()));
        //封装格式
        temp.put("encapsulationFormat", String.valueOf(records.getEncapsulationFormat()));
        //分录标识
        temp.put("entryName", records.getEntryName());
        //自定义sql
        temp.put("customSql", records.getCustomSql());
        //插件地址
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("formFieldMappingDetail", JsonUtil.toString(tempList));
        return temp;
    }


    /**
     * 封装第三方字段
     */
    public static void encapsulationThirdPartyFieldBySql(List<Object> dataList, List<Map<String, String>> fieldList, Map<String, Object> map) {
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (Object object : dataList) {
            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

            Map<String, Object> request = new LinkedHashMap<>();
            for (Map<String, String> temp02Map : fieldList) {
                if (Constants.TRUE.equals(temp02Map.get("isEntryField"))) {
                    request.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                } else {
                    map.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                }
            }
            if (!CollectionUtils.isEmpty(request)) {
                imsList.add(request);
            }
        }
        map.put("children", imsList);
    }

}
