package com.system.controller;

import com.system.serivce.IDockingService;
import com.system.transfer.docking.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class DockingController {

    @Autowired
    private IDockingService dockingService;


    @ApiOperation("分销会员创建")
    @PostMapping("/docking/distribution/member/create")
    public RestResponse dockingDistributionMemberCreate(@RequestBody DockingDistributionMemberCreateInVo inVo) {
        return dockingService.dockingDistributionMemberCreate(inVo);
    }

    @ApiOperation("分销交易创建")
    @PostMapping("/docking/distribution/transaction/create")
    public RestResponse dockingDistributionTransactionCreate(@RequestBody DockingDistributionTransactionCreateInVo inVo) {
        return dockingService.dockingDistributionTransactionCreate(inVo);
    }

    @ApiOperation("分销会员下级查询")
    @PostMapping("/docking/distribution/member/subordinate/list")
    public RestResponse dockingDistributionMemberSubordinateList(@RequestBody DockingDistributionMemberSubordinateListInVo inVo) {
        return dockingService.dockingDistributionMemberSubordinateList(inVo);
    }

    @ApiOperation("分销会员余额")
    @PostMapping("/docking/distribution/member/balance")
    public RestResponse dockingDistributionMemberBalance(@RequestBody DockingDistributionMemberBalanceInVo inVo) {
        return dockingService.dockingDistributionMemberBalance(inVo);
    }

    @ApiOperation("分销会员收益")
    @PostMapping("/docking/distribution/member/profit")
    public RestResponse dockingDistributionMemberProfit(@RequestBody DockingDistributionMemberProfitInVo inVo) {
        return dockingService.dockingDistributionMemberProfit(inVo);
    }


}
