package com.system.controller;

import com.system.serivce.IMallCommonSyncConfigService;
import com.system.transfer.configure.CommonConfigRefreshInVo;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamRefreshInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "商城同步配置")
@RestController
@RequestMapping("/api")
public class MallCommonSyncConfigController {

    @Autowired
    private IMallCommonSyncConfigService mallCommonSyncConfigService;


    @ApiOperation("商城配置刷新")
    @PostMapping("/init/connect/param/refresh")
    public RestResponse initConnectParamRefresh(@RequestBody InitConnectParamRefreshInVo inVo) {
        return mallCommonSyncConfigService.initConnectParamRefresh(inVo);
    }

    @ApiOperation("商城配置校验")
    @PostMapping("/init/connect/param/check")
    public RestResponse initConnectParamCheck(@RequestBody InitConnectParamCheckInVo inVo) {
        return mallCommonSyncConfigService.initConnectParamCheck(inVo);
    }

    @ApiOperation("商城表单配置刷新")
    @PostMapping("/common/config/refresh")
    public RestResponse commonConfigRefresh(@RequestBody CommonConfigRefreshInVo inVo) {
        mallCommonSyncConfigService.commonConfigRefresh(inVo);
        return RestResponse.success();
    }


}
