package com.system.dao;

import com.system.transfer.form.MallCommonConfigListOutVoRecords;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public interface MallCommonConfigMapper {

    /**
     * 商城表单配置列表
     *
     * @param operation 操作
     * @return 列表
     */
    List<MallCommonConfigListOutVoRecords> mallCommonConfigList(Integer operation);

    /**
     * 商城Get表单配置列表
     *
     * @return 列表
     */
    List<MallCommonConfigListOutVoRecords> mallCommonConfigGetList();

    /**
     * 商城通用配置
     *
     * @param id ID
     * @return 商城通用配置
     */
    MallCommonConfigListOutVoRecords getMallCommonConfigById(Integer id);

    /**
     * 商城通用配置字段映射列表
     *
     * @param idList id列表
     * @return 列表
     */
    List<Map<String, Object>> mallFieldMappingList(List<Integer> idList);


}
