package com.system.scheduler;

import com.system.api.CommonHttpApi;
import com.system.constants.Constants;
import com.system.model.InitConnectParam;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Configuration
@EnableScheduling
public class MallLoginScheduler {

    private static final Logger log = LoggerFactory.getLogger(MallLoginScheduler.class);

    @Autowired
    private CommonHttpApi commonHttpApi;


    @Scheduled(fixedRate = 1000 * 60 * 15)
    public void configureTasks() {
        InitConnectParam initConnectParam = commonHttpApi.getInitConnectParam();

        if (StringUtil.isNotNull(initConnectParam)) {
            try {
                Map<String, Object> request = new HashMap<>(2);
                request.put("mobile", initConnectParam.getAccount());
                request.put("password", initConnectParam.getPassword());
                String response = HttpUtil.httpPost(initConnectParam.getMallAddress() + "wx/auth/login_by_mobile", JsonUtil.toString(request)).getBody();

                Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
                if (!CollectionUtils.isEmpty(map)) {
                    if (map.containsKey(Constants.CODE_NAME) && HttpStatus.OK.value() == Integer.parseInt(String.valueOf(map.get(Constants.CODE_NAME)))) {
                        Map<String, Object> data = JsonUtil.toMap(JsonUtil.toString(map.get(Constants.DATE_NAME)), String.class, Object.class);
                        Map<String, Object> header = new HashMap<>(1);
                        header.put("Authorization", data.get("token"));
                        commonHttpApi.setHeader(header);
                        commonHttpApi.setFlag(true);
                        log.info("商城登录成功！");
                    }
                } else {
                    commonHttpApi.setFlag(false);
                    log.info("商城登录失败！");
                }
            } catch (Exception e) {
                e.printStackTrace();
                log.info("商城登录失败！");
            }
        } else {
            commonHttpApi.setFlag(false);
            log.info("商城登录失败！");
        }
    }


}
