package com.system.serivce;

import com.system.transfer.response.RestResponse;

import java.util.Map;

/**
 * @author Inori
 */
public interface IDockingDistributionService {

    /**
     * 对接分销会员创建
     *
     * @param queueId 唯一标识
     * @param data    参数
     * @return 结果
     */
    String dockingDistributionMemberCreate(String queueId, Map<String, Object> data);

    /**
     * 对接订单交易创建
     *
     * @param queueId 唯一标识
     * @param data    参数
     * @return 结果
     */
    String dockingDistributionTransactionCreate(String queueId, Map<String, Object> data);

    /**
     * 对接订单提现创建
     *
     * @return 结果
     */
    RestResponse dockingDistributionWithdrawalCreate();

    /**
     * 查询分销会员下级列表
     *
     * @param memberId 会员标识
     * @param queueId  唯一标识
     * @return 结果
     */
    String dockingDistributionMemberSubordinateList(String queueId, String memberId);

    /**
     * 会员余额
     *
     * @param memberId 会员标识
     * @param queueId  唯一标识
     * @return 结果
     */
    String dockingDistributionMemberBalance(String queueId, String memberId);

    /**
     * 会员收益
     *
     * @param memberId 会员标识
     * @param queueId  唯一标识
     * @return 结果
     */
    String dockingDistributionMemberProfit(String queueId, String memberId);


}
