package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.serivce.IDockingDistributionService;
import com.system.transfer.response.RestResponse;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import com.system.utils.ThirdPartyLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class DockingDistributionServiceImpl implements IDockingDistributionService {

    public String secret;

    @Autowired
    private ThirdPartyLogUtil thirdPartyLogUtil;


    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Override
    public String dockingDistributionMemberCreate(String queueId, Map<String, Object> data) {
        try {
            data.put("secret", secret);
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/memberAdd", JsonUtil.toString(data)).getBody();

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员创建", "0002", queueId, "平台->分销", JsonUtil.toString(data), StringUtil.replaceBlank(result));
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String dockingDistributionTransactionCreate(String queueId, Map<String, Object> data) {
        try {
            data.put("secret", secret);
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/trade", JsonUtil.toString(data)).getBody();

            thirdPartyLogUtil.thirdPartyLogCreate("分销交易创建", "0001", queueId, "平台->分销", JsonUtil.toString(data), StringUtil.replaceBlank(result));
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public RestResponse dockingDistributionWithdrawalCreate() {
        try {
            Map<String, Object> data = new HashMap<>();
            data.put("secret", secret);
            data.put("userId", "admin");
            data.put("amount", "1");
            data.put("accountType", "2");
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/withdraw", JsonUtil.toString(data)).getBody();

            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                return RestResponse.fail("新增提现失败");
            }
            return RestResponse.success();
        } catch (Exception e) {
            e.printStackTrace();
            return RestResponse.fail("新增提现失败");
        }
    }

    @Override
    public String dockingDistributionMemberSubordinateList(String queueId, String memberId) {
        try {
            Map<String, Object> data = new HashMap<>(2);
            data.put("secret", secret);
            data.put("memberId", memberId);
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/subordinate", JsonUtil.toString(data)).getBody();

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员下级查询", "0001", queueId, "平台->分销", JsonUtil.toString(data), StringUtil.replaceBlank(result));
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String dockingDistributionMemberBalance(String queueId, String memberId) {
        try {
            Map<String, Object> data = new HashMap<>(2);
            data.put("secret", secret);
            data.put("memberId", memberId);
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/member/balance", JsonUtil.toString(data)).getBody();

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员余额查询", "0001", queueId, "平台->分销", JsonUtil.toString(data), StringUtil.replaceBlank(result));
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String dockingDistributionMemberProfit(String queueId, String memberId) {
        try {
            Map<String, Object> data = new HashMap<>(2);
            data.put("secret", secret);
            data.put("memberId", memberId);
            data.put("offset", 0);
            data.put("limit", 10000);
            String result = HttpUtil.httpPost("http://192.168.0.34:8080/api/v1/member/profit", JsonUtil.toString(data)).getBody();

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员收益查询", "0001", queueId, "平台->分销", JsonUtil.toString(data), StringUtil.replaceBlank(result));
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }


}
