package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.serivce.IDockingDistributionService;
import com.system.serivce.IDockingService;
import com.system.transfer.docking.*;
import com.system.transfer.response.RestResponse;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import com.system.utils.ThirdPartyLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class DockingServiceImpl implements IDockingService {

    @Autowired
    private IDockingDistributionService dockingDistributionService;

    @Autowired
    private ThirdPartyLogUtil thirdPartyLogUtil;


    @Override
    public RestResponse dockingDistributionMemberCreate(DockingDistributionMemberCreateInVo inVo) {
        if (thirdPartyLogUtil.isExist(inVo.getQueueId()) != 0) {
            return RestResponse.fail("操作失败! QUEUE_ID为: " + inVo.getQueueId() + "的唯一标识已存在");
        }
        Map<String, Object> data = new HashMap<>();
        data.put("disUserId", inVo.getMemberId());
        data.put("disUserName", inVo.getMemberName());
        data.put("disParentId", inVo.getReferrerId());
        if (StringUtil.isBlank(inVo.getReferrerId())) {
            data.put("disPlatformId", "test");
        } else {
            data.put("disPlatformId", "");
        }
        data.put("disNote", inVo.getRemark());

        System.out.println(JsonUtil.toString(data));
        String result = dockingDistributionService.dockingDistributionMemberCreate(inVo.getQueueId(), data);
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            return RestResponse.fail("新增会员失败!" + map.get("errorMessage"));
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse dockingDistributionTransactionCreate(DockingDistributionTransactionCreateInVo inVo) {
        if (thirdPartyLogUtil.isExist(inVo.getQueueId()) != 0) {
            return RestResponse.fail("操作失败! QUEUE_ID为: " + inVo.getQueueId() + "的唯一标识已存在");
        }
        Map<String, Object> data = new HashMap<>();
        data.put("disSetUserId", inVo.getMemberId());
        data.put("orderId", inVo.getOrderId());
        data.put("disNote", inVo.getRemark());
        data.put("disAmount", inVo.getAmount());

        String result = dockingDistributionService.dockingDistributionTransactionCreate(inVo.getQueueId(), data);
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            return RestResponse.fail("新增交易失败! " + map.get("errorMessage"));
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse dockingDistributionMemberSubordinateList(DockingDistributionMemberSubordinateListInVo inVo) {
        if (thirdPartyLogUtil.isExist(inVo.getQueueId()) != 0) {
            return RestResponse.fail("操作失败! QUEUE_ID为: " + inVo.getQueueId() + "的唯一标识已存在");
        }
        String result = dockingDistributionService.dockingDistributionMemberSubordinateList(inVo.getQueueId(), inVo.getMemberId());

        List<Map<String, Object>> recordsList = new ArrayList<>();
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            List<Object> objectList = JsonUtil.toList(JsonUtil.toString(map.get("data")), Object.class);
            List<Map<String, Object>> tempList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());

            List<Map<String, Object>> temp01List = tempList.stream().filter(m -> inVo.getMemberId().equals(m.get("parentId"))).collect(Collectors.toList());
            for (Map<String, Object> temp : temp01List) {
                List<Map<String, Object>> temp02List = tempList.stream().filter(m -> temp.get("memberId").equals(m.get("parentId"))).collect(Collectors.toList());
                recordsList.add(temp);
                recordsList.addAll(temp02List);
            }

            return RestResponse.success(recordsList);
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse dockingDistributionMemberBalance(DockingDistributionMemberBalanceInVo inVo) {
        if (thirdPartyLogUtil.isExist(inVo.getQueueId()) != 0) {
            return RestResponse.fail("操作失败! QUEUE_ID为: " + inVo.getQueueId() + "的唯一标识已存在");
        }
        String result = dockingDistributionService.dockingDistributionMemberBalance(inVo.getQueueId(), inVo.getMemberId());

        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            return RestResponse.success(map.get("data"));
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse dockingDistributionMemberProfit(DockingDistributionMemberProfitInVo inVo) {
        if (thirdPartyLogUtil.isExist(inVo.getQueueId()) != 0) {
            return RestResponse.fail("操作失败! QUEUE_ID为: " + inVo.getQueueId() + "的唯一标识已存在");
        }
        String result = dockingDistributionService.dockingDistributionMemberProfit(inVo.getQueueId(), inVo.getMemberId());

        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            return RestResponse.success(map.get("data"));
        }

        return RestResponse.success();
    }


}
