package com.system.serivce.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.mall.MallCommonApi;
import com.system.order.Order;
import com.system.serivce.ISynchronizationService;
import com.system.transfer.mall.MallTriggerSynchronizationInVo;
import com.system.transfer.mall.SynchronizationRecordsListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Service
public class SynchronizationServiceImpl implements ISynchronizationService {

    private ExecutorService threadPool = new ThreadPoolExecutor(10, 10,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<Runnable>(1024),
            new ThreadFactoryBuilder().setNameFormat("syn-pool-%d").build(),
            new ThreadPoolExecutor.AbortPolicy());

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;

    @Autowired
    private IMallSyncServiceImpl mallSyncService;

    @Autowired
    private MallCommonApi mallCommonApi;


    @Override
    public void mallTriggerSynchronization(MallTriggerSynchronizationInVo inVo) {
        threadPool.execute(() -> {
            this.synchronization(inVo.getIdList());
        });
    }

    @Override
    public void mallSynchronization() {
        threadPool.execute(() -> {
            this.synchronization(new ArrayList<>());
        });
    }

    @Transactional(rollbackFor = Exception.class)
    public void synchronization(List<Integer> request) {
        List<Map<String, Object>> tempList = mallCommonApi.getSynchronizationRecords(request);

        if (!CollectionUtils.isEmpty(tempList)) {
            synchronizationRecordsMapper.synchronizationRecordsTempCreate(tempList);
        }

        //更新状态
        mallCommonApi.mallSynchronizedRecordsUpdate(tempList);

        List<Map<String, Object>> dataList = synchronizationRecordsMapper.synchronizationRecordsTempList();
        if (!CollectionUtils.isEmpty(dataList)) {
            synchronizationRecordsMapper.synchronizationRecordsCreate(dataList);

            List<Integer> idList = dataList.stream().map(m -> Integer.parseInt(m.get("id").toString())).collect(Collectors.toList());
            synchronizationRecordsMapper.synchronizationRecordsTempDelete(idList);
        }

        threadPool.execute(() -> {
            List<SynchronizationRecordsListOutVoRecords> recordsList = synchronizationRecordsMapper.synchronizationRecordsListByStatus(Stream.of(0).collect(Collectors.toList()));
            List<Integer> idList = recordsList.stream().map(SynchronizationRecordsListOutVoRecords::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                synchronizationRecordsMapper.synchronizationRecordsUpdateByIdList(idList);
            }

            //TODO 筛选FID相同的数据，拿id相同的数据再做同步
            List<String> fidList = recordsList.stream().map(SynchronizationRecordsListOutVoRecords::getFid).distinct().collect(Collectors.toList());

            Map<Integer, Order> map=new HashMap<>();

            int[] entryId = new int[recordsList.size()];
            System.out.println("recordsList===="+recordsList);
            for (SynchronizationRecordsListOutVoRecords records : recordsList) {
                if (!"LQKJ_IMSSync".equals(records.getForm())) {

                    if(!map.containsKey(records.getDataId())){
                        Order order=new Order();
                        List<Integer> entryIds=new ArrayList<>();
                        order.setSror(records);
                        entryIds.add(records.getEntryId());
                        order.setEntryIds(entryIds);
                        map.put(records.getDataId(),order);
                    }else{
                        Order order=map.get(records.getDataId());
                        order.getEntryIds().add(records.getEntryId());
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                        break;
                }

            }
            System.out.println("map===="+map);
            for(Map.Entry<Integer, Order> maps:map.entrySet()){
                mallSyncService.synchronization(maps.getValue().getSror().getId(),maps.getValue().getSror().getForm(),maps.getValue().getSror().getDataId(), maps.getValue().getEntryIds());
            }

        });
    }


}
