package com.system.utils;

import com.system.constants.Constants;
import com.system.dao.MallLogMapper;
import com.system.transfer.log.MallLogCreateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author Inori
 */
@Component
public class MallLogUtil {

    @Autowired
    private MallLogMapper mallLogMapper;


    public void mallLogCreate(String name, String docType, String queueId, Integer operation, String request, String response) {
        MallLogCreateInVo inVo = new MallLogCreateInVo();
        inVo.setName(name);
        inVo.setCode(docType);
        inVo.setQueueId(queueId);
        inVo.setOperation(operation);
        inVo.setRequest(request);
        inVo.setResponse(response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                inVo.setFlag(1);
            } else {
                inVo.setFlag(0);
                inVo.setMessage(response);
            }
        } else {
            inVo.setFlag(0);
        }

        mallLogMapper.mallLogCreate(inVo);
    }

    public void thirdPartyErrorLogCreate(String name, String sFormId, String queueId, Integer operation, String request, String message) {
        MallLogCreateInVo inVo = new MallLogCreateInVo();
        inVo.setName(name);
        inVo.setCode(sFormId);
        inVo.setQueueId(queueId);
        inVo.setOperation(operation);
        inVo.setRequest(request);
        inVo.setFlag(0);
        inVo.setMessage(message);

        mallLogMapper.mallLogCreate(inVo);
    }


}
