package com.framework.core.config;

import io.minio.MinioClient;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

//@RefreshScope
@Data
@Component
@ConfigurationProperties(prefix = "doc.oss")
public class MinioConfig {

    // endPoint是一个URL，域名，IPv4或者IPv6地址
    private String endpoint;

    private String resourcesUrl;
    // TCP/IP端口号
//    private int port;

    private String accessKeyId;

    private String accessKeySecret;

    // 如果是true，则用的是https而不是http,默认值是true
//    private Boolean secure;
    private Integer type;
    // 默认存储桶
    private String bucket;

    @Value("${doc.oss.maxLength:20}")
    private Integer maxLength;
//    @Bean
//    public MinioClient getMinioClient() throws InvalidPortException, InvalidEndpointException {
//        MinioClient minioClient = new MinioClient(endpoint, port, accessKeyId, accessKeySecret, secure);
//        return minioClient;
//    }

    @Bean
    public MinioClient getMinioClient() {
        MinioClient build = MinioClient.builder().endpoint(endpoint)
                .credentials(accessKeyId, accessKeySecret)
                .build();
        return build;
    }
}
