package com.nzwz.api;

import com.nzwz.exception.KingdeeConnectException;
import com.nzwz.model.InitConnectParam;
import com.nzwz.utils.StringUtil;
import com.nzwz.dao.InitConnectParamMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Slf4j
@Component
public class KingDeeApi {

    private final String serviceNameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";

    private final String serviceNameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";

    private final String updateService = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub";

    private InitConnectParam initConnectParam;

    private static final String LOGIN_MESSAGE = "金蝶服务器地址异常";

    public boolean flag = false;

    public KingDeeK3CloudApi kingDeeK3CloudApi;

    @Autowired
    InitConnectParamMapper initConnectParamMapper;


    @PostConstruct
    public void init() {
        initConnectParam = initConnectParamMapper.selectById("1");
        kingDeeK3CloudApi = new KingDeeK3CloudApi(initConnectParam.getK3CloudUrl());
    }

    public InitConnectParam getInitConnectParam() {
        return initConnectParam;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setKingDeeK3CloudApi(KingDeeK3CloudApi kingDeeK3CloudApi) {
        this.kingDeeK3CloudApi = kingDeeK3CloudApi;
    }

    /**
     * 同步方法
     */
    public String synchronization(List<Map<String, Object>> data) {
        String result;
        try {
            if (flag) {
                Map<String, Object> map = new LinkedHashMap<>();
                map.put("Parameters", new HashMap<>(1));
                map.put("Type", "1");
                map.put("Table", data);
                Map<String, Object> tempMap = new LinkedHashMap<>();
                tempMap.put("FNumber", "111");
                map.put("Model", tempMap);
                result = kingDeeK3CloudApi.execute("Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExcuteOperation", new Object[]{"Org_AllocateStrTest", "DoNothing", map}, String.class);
            } else {
                throw new KingdeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(LOGIN_MESSAGE);
        }
        return result;
    }

    private String stringKey(Map<String, String> map) {
        StringBuilder keys = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(keys)) {
                keys.append(", ").append(entry.getKey());
            } else {
                keys = new StringBuilder(entry.getKey());
            }
        }
        if (StringUtil.isNotBlank(keys.toString())) {
            return "\"FieldKeys\":\"" + keys.toString() + "\"";
        }
        return "";
    }

    private String stringWhere(Map<String, String> map) {
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(where)) {
                where.append(" AND ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
            } else {
                where = new StringBuilder(entry.getKey() + "='" + entry.getValue() + "'");
            }
        }
        if (StringUtil.isNotBlank(where.toString())) {
            return ",\"FilterString\":\"" + where.toString() + "\"";
        }
        return "";
    }

}

