package com.nzwz.quartz.job;

import com.nzwz.serivce.ISynchronizationService;
import org.apache.commons.lang.time.DateFormatUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;

/**
 * @author Inori
 */
@Component
public class SynchronizationJob implements Job {

    @Autowired
    private ISynchronizationService synchronizationService;


    @Override
    public void execute(JobExecutionContext jobExecutionContext) {
        System.out.println("开启自动同步定时任务，开始时间: " + DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        synchronizationService.synchronization(new ArrayList<>());
    }


}
