package com.oauth.message.websocket;

import com.alibaba.fastjson.JSONObject;
import com.framework.core.constant.WebsocketConst;
import com.framework.core.response.StarBosResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("webSocketApi")
public class TestController {

    @Autowired
    private Socket webSocket;



    @PostMapping("/sendAll")
    public StarBosResult<String> sendAll(@RequestBody JSONObject jsonObject) {
        StarBosResult<String> result = new StarBosResult<String>();
        String message = jsonObject.getString("message");
        JSONObject obj = new JSONObject();
        obj.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_TOPIC);
        obj.put(WebsocketConst.MSG_ID, "M0001");
        obj.put(WebsocketConst.MSG_TXT, message);
        webSocket.sendAllMessage(obj.toJSONString());
        result.successOk("群发！");
        return result;
    }

    @PostMapping("/sendUser")
    public StarBosResult<String> sendUser(@RequestBody JSONObject jsonObject) {
        StarBosResult<String> result = new StarBosResult<String>();
        String userId = jsonObject.getString("userId");
        String message = jsonObject.getString("message");
        JSONObject obj = new JSONObject();
        obj.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_USER);
        obj.put(WebsocketConst.MSG_USER_ID, userId);
        obj.put(WebsocketConst.MSG_ID, "M0001");
        obj.put(WebsocketConst.MSG_TXT, message);
        webSocket.sendOneMessage(userId, obj.toJSONString());
        result.successOk("单发");
        return result;
    }
    @GetMapping("/push")
    public void push()
    {
        WebSocketService.sendMessage("1","badao");
    }


}