package com.oauth.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 用户信息
 */

@Data
@TableName("sys_user_message")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户信息对象", description = "用户信息对象")
public class UserMessage implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "id")
    @TableId(type = IdType.INPUT)
    private Long userId;

    /**
     * 用户名
     */

    @ApiModelProperty(value = "用户名")
    private String name;

    /**
     * 头像地址
     */
    @ApiModelProperty(value = "头像")
    private String avatar;
    /**
     *
     */
    @ApiModelProperty(value = "用户介绍")
    private String introduction;

    /**
     * 账号
     */
    @ApiModelProperty(value = "账号")
    private String FauthAccount;
    /**
     * 英文名
     */
    @ApiModelProperty(value = "英文名")
    private String fenglishName;
    /**
     * 工号
     */
    @ApiModelProperty(value = "工号")
    private String fworkNo;

    /**
     * 部门
     */
    @ApiModelProperty(value = "部门")
    private String fdept;
    /**
     * 手机
     */
    @ApiModelProperty(value = "手机")
    private String fphone;
    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String fmail;
    /**
     * 工作地点
     */
    @ApiModelProperty(value = "工作地点")
    private String fworkAddr;

    /**
     * 入职日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "入职日期")
    private Date finductionDate;
    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String fposition;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String fstate;
    //创建日期
    @ApiModelProperty(value = "创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date fdate;
    //    创建人
    @ApiModelProperty(value = "创建人")
    private String fcreator;


    @TableField(exist = false)
    private List<String> roles;


}
