package com;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;

@SpringBootApplication
public class StarbosSystemApplication {

    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext run = SpringApplication.run(StarbosSystemApplication.class, args);
        Environment env = run.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        System.out.println("\n----------------------------------------------------------\n\t" +
                "Application starbos is running! Access URLs:\n\t" +
                "Local: \t\thttp://localhost:" + port  +"/\n\t" +
                "External: \thttp://" + ip + ":" + port  + "/\n\t" +
                "Swagger-ui: \thttp://" + ip + ":" + port  + "/swagger-ui.html\n\t" +
                "Doc文档: \thttp://" + ip + ":" + port  + "/doc.html\n" +
                "----------------------------------------------------------");
    }
    /**
     * tomcat-embed-jasper引用后提示jar找不到的问题
     */
//    @Bean
//    public TomcatServletWebServerFactory tomcatFactory() {
//        return new TomcatServletWebServerFactory() {
//            @Override
//            protected void postProcessContext(Context context) {
//                ((StandardJarScanner) context.getJarScanner()).setScanManifest(false);
//            }
//        };
//    }
}
