package com.nzwz.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.nzwz.model.Log;
import com.nzwz.transfer.log.LogListInVo;
import com.nzwz.transfer.log.LogListOutVoRecords;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface LogMapper extends BaseMapper<Log> {

    /**
     * 日志列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<LogListOutVoRecords> logList(@Param("page") Page<LogListOutVoRecords> page, @Param("inVo") LogListInVo inVo);

    /**
     * 根据内容查询最新同步时间
     *
     * @param content 内容
     * @return 同步时间
     */
    String slectOrderCreateTimeByContent(String content);


    /**
     * 根据时间查询失败同步日志
     *
     * @param createTime 时间
     * @return 失败同步日志
     */
    List<Log> selectLogByFlag(String createTime);


}
