package com.oauth.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.framework.core.utils.oConvertUtils;
import com.oauth.system.entity.SysDepart;
import com.oauth.system.entity.SysUserDepart;
import com.oauth.system.entity.UserMessage;
import com.oauth.system.mapper.SysUserDepartMapper;
import com.oauth.system.model.DepartIdModel;
import com.oauth.system.service.ISysDepartService;
import com.oauth.system.service.ISysUserDepartService;
import com.oauth.system.service.IUserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <P>
 * 用户部门表实现类
 * <p/>
 * @Author ZhiLin
 *@since 2019-02-22
 */
@Service
public class SysUserDepartServiceImpl extends ServiceImpl<SysUserDepartMapper, SysUserDepart> implements ISysUserDepartService {
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private IUserMessageService sysUserService;


    /**
     * 根据用户id查询部门信息
     */
    @Override
    public List<DepartIdModel> queryDepartIdsOfUser(String userId) {
        LambdaQueryWrapper<SysUserDepart> queryUDep = new LambdaQueryWrapper<SysUserDepart>();
        LambdaQueryWrapper<SysDepart> queryDep = new LambdaQueryWrapper<SysDepart>();
        try {
            queryUDep.eq(SysUserDepart::getUserId, userId);
            List<String> depIdList = new ArrayList<>();
            List<DepartIdModel> depIdModelList = new ArrayList<>();
            List<SysUserDepart> userDepList = this.list(queryUDep);
            if(userDepList != null && userDepList.size() > 0) {
                for(SysUserDepart userDepart : userDepList) {
                    depIdList.add(userDepart.getDepId());
                }
                queryDep.in(SysDepart::getId, depIdList);
                List<SysDepart> depList = sysDepartService.list(queryDep);
                if(depList != null || depList.size() > 0) {
                    for(SysDepart depart : depList) {
                        depIdModelList.add(new DepartIdModel().convertByUserDepart(depart));
                    }
                }
                return depIdModelList;
            }
        }catch(Exception e) {
            e.fillInStackTrace();
        }
        return null;


    }


    /**
     * 根据部门id查询用户信息
     */
    @Override
    public List<UserMessage> queryUserByDepId(String depId) {
        LambdaQueryWrapper<SysUserDepart> queryUDep = new LambdaQueryWrapper<SysUserDepart>();
        queryUDep.eq(SysUserDepart::getDepId, depId);
        List<String> userIdList = new ArrayList<>();
        List<SysUserDepart> uDepList = this.list(queryUDep);
        if(uDepList != null && uDepList.size() > 0) {
            for(SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            List<UserMessage> userList = (List<UserMessage>) sysUserService.listByIds(userIdList);
            //update-begin-author:taoyan date:201905047 for:接口调用查询返回结果不能返回密码相关信息
            for (UserMessage sysUser : userList) {
//                sysUser.setSalt("");
//                sysUser.setPassword("");
            }
            //update-end-author:taoyan date:201905047 for:接口调用查询返回结果不能返回密码相关信息
            return userList;
        }
        return new ArrayList<UserMessage>();
    }

    /**
     * 根据部门code，查询当前部门和下级部门的 用户信息
     */
    @Override
    public List<UserMessage> queryUserByDepCode(String depCode,String realname) {
        LambdaQueryWrapper<SysDepart> queryByDepCode = new LambdaQueryWrapper<SysDepart>();
        queryByDepCode.likeRight(SysDepart::getOrgCode,depCode);
        List<SysDepart> sysDepartList = sysDepartService.list(queryByDepCode);
        List<String> depIds = sysDepartList.stream().map(SysDepart::getId).collect(Collectors.toList());

        LambdaQueryWrapper<SysUserDepart> queryUDep = new LambdaQueryWrapper<SysUserDepart>();
        queryUDep.in(SysUserDepart::getDepId, depIds);
        List<String> userIdList = new ArrayList<>();
        List<SysUserDepart> uDepList = this.list(queryUDep);
        if(uDepList != null && uDepList.size() > 0) {
            for(SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            LambdaQueryWrapper<UserMessage> queryUser = new LambdaQueryWrapper<UserMessage>();
            queryUser.in(UserMessage::getUserId,userIdList);
            if(oConvertUtils.isNotEmpty(realname)){
                queryUser.like(UserMessage::getFauthAccount,realname.trim());
            }
            List<UserMessage> userList = (List<UserMessage>) sysUserService.list(queryUser);
            //update-begin-author:taoyan date:201905047 for:接口调用查询返回结果不能返回密码相关信息
            for (UserMessage sysUser : userList) {
//                sysUser.setSalt("");
//                sysUser.setPassword("");
            }
            //update-end-author:taoyan date:201905047 for:接口调用查询返回结果不能返回密码相关信息
            return userList;
        }
        return new ArrayList<UserMessage>();
    }

}
