package com.oauth.system.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.framework.core.constant.CacheConstant;
import com.framework.core.exception.StarBosException;
import com.framework.core.response.StarBosResult;
import com.oauth.system.dto.AuthAccountDTO;
import com.oauth.system.entity.UserMessage;
import com.oauth.system.mapper.UserMessageMapper;
import com.oauth.system.model.RegisterModel;
import com.oauth.system.service.IUserMessageService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserMessageServiceImpl extends ServiceImpl<UserMessageMapper, UserMessage> implements IUserMessageService {

    @Autowired
    private MapperFacade mapperFacade;

    @Autowired
    private AccountServiceImpl accountService;

    //    添加用户账号及用户信息
    @Transactional(rollbackFor = Exception.class)
    public Long save(RegisterModel registerModel) {
//生成用户账号，并返回账号ID
        AuthAccountDTO authAccountDTO = new AuthAccountDTO();
        authAccountDTO.setUsername(registerModel.getFauthAccount());
        authAccountDTO.setPassword(registerModel.getPassword());
        StarBosResult<Long> serverResponse = accountService.save(authAccountDTO);
        //比较serverResponse的状态码，非ok，则抛出异常
        // 抛异常回滚
        if (!serverResponse.isSuccess()) {
            throw new StarBosException(serverResponse.getMsg());
        }
        Long userId = serverResponse.getData();
//        将model转为entity
        UserMessage userMessage = mapperFacade.map(registerModel, UserMessage.class);
//        绑定返回的账号id
        userMessage.setUserId(userId);
//        保存用户信息
        this.save(userMessage);
        return serverResponse.getData();
    }


    //    删除账号及用户信息
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean remove(long accountId) {
//        删除用户账号
        StarBosResult<Void> serverResponse = accountService.deleteByUserId(accountId);
        // 抛异常回滚
        //比较Response的状态码，非ok，则抛出异常
        if (!serverResponse.isSuccess()) {
            throw new StarBosException(serverResponse.getMsg());
        }
        //        删除用户信息
        boolean b = this.removeById(accountId);
        return b;
    }

    //    更新用户信息及拥有的角色
    @CacheEvict(value = {CacheConstant.SYS_USERS_CACHE}, allEntries = true)
    @Transactional
    public void editUserWithRole(UserMessage user) {
        boolean b = this.updateById(user);
        //先删后加
        StarBosResult<Void> serverResponse = accountService.editUserRole(user.getUserId(), user.getRoles());
        //比较Response的状态码，非ok，则抛出异常
        if (!serverResponse.isSuccess()) {
//            抛异常回滚
            throw new StarBosException(serverResponse.getMsg());
        }

    }
}
