package com.nzwz.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.nzwz.serivce.ILogService;
import com.nzwz.transfer.log.LogListInVo;
import com.nzwz.transfer.log.LogListOutVo;
import com.nzwz.transfer.log.LogListOutVoRecords;
import com.nzwz.dao.LogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class LogServiceImpl implements ILogService {

    @Autowired
    private LogMapper logMapper;


    @Override
    public LogListOutVo logList(LogListInVo inVo) {
        Page<LogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<LogListOutVoRecords> recordsList = logMapper.logList(page, inVo);

        LogListOutVo outVo = new LogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
