package com.nzwz.controller;

import com.nzwz.common.response.RestResponse;
import com.nzwz.transfer.log.LogListInVo;
import com.nzwz.transfer.log.LogListOutVo;
import com.nzwz.serivce.ILogService;
import com.nzwz.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "日志记录")
@RestController
@RequestMapping("/api")
public class LogController {

    @Autowired
    private ILogService logService;


    @ApiOperation("日志列表")
    @GetMapping("/log/list")
    public RestResponse logList(@ModelAttribute @Validated LogListInVo inVo) {
        LogListOutVo outVo = logService.logList(inVo);
        return RestResponse.success(outVo);
    }


}
