package com.nzwz.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.nzwz.model.TableRelation;
import com.nzwz.transfer.tablerelation.TableRelationCreateInVoRecords;
import com.nzwz.transfer.tablerelation.TableRelationListInVo;
import com.nzwz.transfer.tablerelation.TableRelationListOutVoRecords;
import com.nzwz.transfer.tablerelation.TableRelationUpdateInVoRecords;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface TableRelationMapper extends BaseMapper<TableRelation> {

    /**
     * 表关系列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<TableRelationListOutVoRecords> tableRelationList(@Param("page") Page<TableRelationListOutVoRecords> page, @Param("inVo") TableRelationListInVo inVo);

    /**
     * 表关系录入
     *
     * @param inVo 条件
     */
    void tableRelationCreate(TableRelationCreateInVoRecords inVo);

    /**
     * 表关系编辑
     *
     * @param inVo 条件
     */
    void tableRelationUpdate(TableRelationUpdateInVoRecords inVo);

    /**
     * 表关系删除
     *
     * @param id ID
     */
    void tableRelationDelete(Integer id);


}
