package com.nzwz.scheduler;

import com.nzwz.api.KingDeeApi;
import com.nzwz.api.KingDeeK3CloudApi;
import com.nzwz.model.InitConnectParm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

/**
 * @author Inori
 */
@Order(-1)
@Configuration
@EnableScheduling
public class KingDeeLoginScheduler {

    private static final Logger log = LoggerFactory.getLogger(KingDeeLoginScheduler.class);

    @Autowired
    private KingDeeApi kingDeeApi;


    @Scheduled(fixedRate = 1000 * 60 * 20)
    public void configureTasks() {
        InitConnectParm initConnectParm = kingDeeApi.getInitConnectParm();

        KingDeeK3CloudApi kingDeeK3CloudApi = new KingDeeK3CloudApi(initConnectParm.getK3CloudUrl());
        Boolean flag = null;
        try {
            flag = kingDeeK3CloudApi.login(initConnectParm.getDbid(), initConnectParm.getUid(), initConnectParm.getPwd(), initConnectParm.getLang());
        } catch (Exception e) {
            flag = false;
            log.info("金蝶云登录失败！");
        }

        if (flag) {
            log.info("金蝶云登录成功！");
        } else {
            log.info("金蝶云登录失败！");
        }

        kingDeeApi.setFlag(flag);
        kingDeeApi.setKingDeeK3CloudApi(kingDeeK3CloudApi);
    }


}
