package com.oauth.system.entity;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@TableName("sys_permission")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "sys_permission对象", description = "权限")
@ExcelIgnoreUnannotated
public class SysPermission  implements Serializable  {
    private static final long serialVersionUID = 1L;
    //编码
    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    @ExcelProperty(value = "主键",index = 2)
    private String id;
    // 菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)
    @ApiModelProperty(value = "菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)")
    private Integer type;
    //菜单名称
    @ExcelProperty(value = "菜单名称",index = 3)
    @ApiModelProperty(value = "菜单名称")
    private String title;
    // 表单key
    @ExcelProperty(value = "表单key",index = 4)
    @ApiModelProperty(value = "表单key")
    private String permTag;
    // 路径
    @ExcelProperty(value = "路径")
    @ApiModelProperty(value = "路径")
    private String path;
    //组件
    @ExcelProperty(value = "组件")
    @ApiModelProperty(value = "组件")
    private String component;
    //菜单图标
    @ExcelProperty(value = "菜单图标")
    @ApiModelProperty(value = "菜单图标")
    private String icon;
    /**
     * 是否叶子节点: 1:是  0:不是
     */
    @ExcelProperty(value = "是否叶子节点")
    @TableField(value = "is_leaf")
    @ApiModelProperty(value = "是否叶子节点: 1:是  0:不是")
    private Boolean hasChildren;

    /**
     * 菜单排序
     */
    @ApiModelProperty(value = "菜单排序")
    private Double sortNo;
    //父节点
    @ApiModelProperty(value = "父节点")
    private String parentId;
    //备注
    @ApiModelProperty(value = "备注")
    private String fremarks;
    //状态
    @ApiModelProperty(value = "状态")
    private String fstatus;

    @ApiModelProperty(value = "创建人")
    private String fcreator;
    //    更新日期
    @ApiModelProperty(value = "更新日期")
    private Date fmodifyDate;
    //    更新人
    @ApiModelProperty(value = "更新人")
    private String fmodify;
    @TableField(exist = false)
    @ApiModelProperty(value = "次级菜单")
    private List<SysPermission> children;
}
