package com.nzwz.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.nzwz.transfer.tablerelation.*;
import com.nzwz.dao.TableRelationMapper;
import com.nzwz.serivce.ITableRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class TableRelationServiceImpl implements ITableRelationService {

    @Autowired
    private TableRelationMapper tableRelationMapper;


    @Override
    public TableRelationListOutVo tableRelationList(TableRelationListInVo inVo) {
        Page<TableRelationListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<TableRelationListOutVoRecords> recordsList = tableRelationMapper.tableRelationList(page, inVo);

        TableRelationListOutVo outVo = new TableRelationListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationCreate(TableRelationCreateInVo inVo) {
        for (TableRelationCreateInVoRecords records : inVo.getRecordsList()) {
            tableRelationMapper.tableRelationCreate(records);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationUpdate(TableRelationUpdateInVo inVo) {
        for (TableRelationUpdateInVoRecords records : inVo.getRecordsList()) {
            tableRelationMapper.tableRelationUpdate(records);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationDelete(TableRelationDeleteInVo inVo) {
        for (Integer id : inVo.getIdList()) {
            tableRelationMapper.tableRelationDelete(id);
        }
    }


}
