package com.nzwz.config;

import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
public class ThreadLocalConfig {

    private static ThreadLocal<Map<String, Object>> THREAD_LOCAL = new ThreadLocal<>();


    public static Map<String, Object> get() {
        if (CollectionUtils.isEmpty(THREAD_LOCAL.get())) {
            ThreadLocalConfig.set(new HashMap<>());
        }
        return THREAD_LOCAL.get();
    }


    public static void set(Map<String, Object> map) {
        THREAD_LOCAL.set(map);
    }


    public static void remove() {
        THREAD_LOCAL.remove();
    }


}
