package com.nzwz.controller;

import com.nzwz.common.response.RestResponse;
import com.nzwz.transfer.synchronization.InitConnectParmCreateInVo;
import com.nzwz.transfer.synchronization.InitConnectParmOutVo;
import com.nzwz.serivce.ISynchronizationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "自动同步")
@RestController
@RequestMapping("/api")
public class SynchronizationController {

    @Autowired
    private ISynchronizationService synchronizationService;


    @ApiOperation("开启自动同步")
    @GetMapping("/start/synchronization")
    public RestResponse startSynchronization() {
        return synchronizationService.startSynchronization();
    }

    @ApiOperation("关闭自动同步")
    @GetMapping("/turn/off/synchronization")
    public RestResponse turnOffSynchronization() {
        return synchronizationService.turnOffSynchronization();
    }

    @ApiOperation("查询金蝶参数")
    @GetMapping("/init/connect/parm")
    public RestResponse initConnectParm() {
        InitConnectParmOutVo outVo = synchronizationService.initConnectParm();
        return RestResponse.success(outVo);
    }

    @ApiOperation("保存金蝶参数")
    @PostMapping("/init/connect/parm/create")
    public RestResponse initConnectParmCreate(@RequestBody @Validated InitConnectParmCreateInVo inVo) {
        return synchronizationService.initConnectParmCreate(inVo);
    }

    @ApiOperation("手动开启自动同步")
    @GetMapping("/manual/synchronization")
    public RestResponse manualSynchronization() {
        synchronizationService.synchronization();
        return RestResponse.success();
    }

    @ApiOperation("手动重新同步错误同步")
    @GetMapping("/abnormal/synchronization")
    public RestResponse abnormalSynchronization() {
        synchronizationService.abnormalAgainSynchronization();
        return RestResponse.success();
    }


}
