package com.nzwz.controller;

import com.nzwz.common.response.RestResponse;
import com.nzwz.transfer.tablerelation.*;
import com.nzwz.serivce.ITableRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "金蝶表关系")
@RestController
@RequestMapping("/api")
public class TableRelationController {

    @Autowired
    private ITableRelationService tableRelationService;


    @ApiOperation("表关系列表")
    @GetMapping("/table/relation/list")
    public RestResponse tableRelationList(@ModelAttribute @Validated TableRelationListInVo inVo) {
        TableRelationListOutVo outVo = tableRelationService.tableRelationList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("表关系录入")
    @PostMapping("/table/relation/create")
    public RestResponse tableRelationCreate(@RequestBody @Validated TableRelationCreateInVo inVo) {
        tableRelationService.tableRelationCreate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("表关系修改")
    @PutMapping("/table/relation/update")
    public RestResponse tableRelationUpdate(@RequestBody @Validated TableRelationUpdateInVo inVo) {
        tableRelationService.tableRelationUpdate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("表关系删除")
    @DeleteMapping("/table/relation/delete")
    public RestResponse tableRelationDelete(@ModelAttribute @Validated TableRelationDeleteInVo inVo) {
        tableRelationService.tableRelationDelete(inVo);
        return RestResponse.success();
    }


}
