package com.nzwz.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.nzwz.common.constants.Constants;
import com.nzwz.transfer.tablerelation.*;
import com.nzwz.dao.TableRelationMapper;
import com.nzwz.serivce.ITableRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class TableRelationServiceImpl implements ITableRelationService {

    @Autowired
    private TableRelationMapper tableRelationMapper;


    @Override
    public TableRelationListOutVo tableRelationList(TableRelationListInVo inVo) {
        List<TableRelationListOutVoRecords> recordsList = tableRelationMapper.tableRelationList(inVo);
        List<TableRelationListOutVoRecords> tempList = getTableRelationTree(Constants.ROOT_MENU_CODE, recordsList);
        List<TableRelationListOutVoRecords> result = tempList.stream()
                .sorted(Comparator.comparing(TableRelationListOutVoRecords::getCreateTime).reversed())
                .collect(Collectors.toList())
                .subList(inVo.getPageNo() * inVo.getPageSize() - 10, inVo.getPageNo() * inVo.getPageSize());

        TableRelationListOutVo outVo = new TableRelationListOutVo();
        outVo.setTotal(recordsList.size());
        outVo.setRecords(result);
        return outVo;
    }

    private List<TableRelationListOutVoRecords> getTableRelationTree(String tableHeader, List<TableRelationListOutVoRecords> recordsList) {
        List<TableRelationListOutVoRecords> tempList = recordsList.stream().filter(m -> tableHeader.equals(m.getSubTableHeader())).collect(Collectors.toList());

        for (TableRelationListOutVoRecords records : tempList) {
            records.setChildren(this.getTableRelationTree(records.getTableHeader(), recordsList));
        }

        return tempList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationCreate(TableRelationCreateInVo inVo) {
        for (TableRelationCreateInVoRecords records : inVo.getRecordsList()) {
            tableRelationMapper.tableRelationCreate(records);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationUpdate(TableRelationUpdateInVo inVo) {
        for (TableRelationUpdateInVoRecords records : inVo.getRecordsList()) {
            tableRelationMapper.tableRelationUpdate(records);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void tableRelationDelete(TableRelationDeleteInVo inVo) {
        for (Integer id : inVo.getIdList()) {
            tableRelationMapper.tableRelationDelete(id);
        }
    }


}
