package com.oauth.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

import java.util.Date;

// 用户信息表
@Data
@TableName("sys_user")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class SysUserAccount implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DISTRIBUTED_ID_KEY = "starbos-auth-user-account";
    @TableId(type = IdType.AUTO)
    private Long id;
    @NotBlank(message = "account not blank")
    private String username;

    private String realname;
    @NotBlank(message = "password not blank")
    private String password;

    private Date createDate;

    private Date lastLoginTime;

    private Boolean enabled;

    private Boolean accountNonExpired;

    private Boolean accountNonLocked;

    private Boolean credentialsNonExpired;


}
