package com.oauth.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.framework.core.utils.oConvertUtils;
import com.oauth.system.entity.SysRolePermission;
import com.oauth.system.mapper.SysRolePermissionMapper;
import com.oauth.system.service.ISysRolePermissionService;
import org.springframework.stereotype.Service;


import java.util.*;

@Service
public class SysRolePermissionServiceImpl extends ServiceImpl<SysRolePermissionMapper, SysRolePermission> implements ISysRolePermissionService {

    @Override
    public List<SysRolePermission> selectInPermId(List<Integer> ids) {
        QueryWrapper<SysRolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
        rolePermissionQueryWrapper.in("perm_id", ids);
        List<SysRolePermission> rolePermissions = this.getBaseMapper().selectList(rolePermissionQueryWrapper);//
        return rolePermissions;
    }

    @Override
    public List<SysRolePermission> selectInUser(List<String> roleIds, List<String> permIds) {
        LambdaQueryWrapper<SysRolePermission> rolePermissionQueryWrapper = new LambdaQueryWrapper<>();
        rolePermissionQueryWrapper.in(SysRolePermission::getRoleId, roleIds).and(rolePermissionLambdaQueryWrapper -> rolePermissionLambdaQueryWrapper.in(SysRolePermission::getPermId, permIds));
        List<SysRolePermission> rolePermissions;
        try {
            rolePermissions = this.list(rolePermissionQueryWrapper);
        } catch (Exception e) {
            rolePermissions = new ArrayList<>();
        }

        return rolePermissions;
    }

    @Override
    public void saveRolePermission(String roleId, List<String> permissionIds, List<String> lastPermissionIds) {

        List<String> add = getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            List<SysRolePermission> list = new ArrayList<SysRolePermission>();
            for (String p : add) {
                if (oConvertUtils.isNotEmpty(p)) {
                    SysRolePermission rolepms = new SysRolePermission(roleId, p);
                    list.add(rolepms);
                }
            }
            this.saveBatch(list);
        }

        List<String> delete = getDiff(permissionIds, lastPermissionIds);
        if (delete != null && delete.size() > 0) {
            for (String permissionId : delete) {
                this.remove(new QueryWrapper<SysRolePermission>().lambda().eq(SysRolePermission::getRoleId, roleId).eq(SysRolePermission::getPermId, permissionId));
            }
        }
    }

    /**
     * 从diff中找出main中没有的元素
     *
     * @param main
     * @param diff
     * @return
     */
    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty(diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty(main)) {
            return Arrays.asList(diff.split(","));
        }

        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        Map<String, Integer> map = new HashMap<>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        List<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (oConvertUtils.isNotEmpty(key) && !map.containsKey(key)) {
                res.add(key);
            }
        }
        return res;
    }

    private List<String> getDiff(List<String> main, List<String> diff) {
        if (null == diff || diff.isEmpty()) {
            return null;
        }
        if (null == main || main.isEmpty()) {
            return diff;
        }

        List<String> mainArr = main;
        List<String> diffArr = diff;
        Map<String, Integer> map = new HashMap<>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        List<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (oConvertUtils.isNotEmpty(key) && !map.containsKey(key)) {
                res.add(key);
            }
        }
        return res;
    }

}
