package com.oauth.utils;

import com.oauth.system.entity.SysPermission;
import com.framework.core.utils.oConvertUtils;

public class PermissionDataUtil {

    /**
     * 智能处理错误数据，简化用户失误操作
     *
     * @param permission
     */
    public static SysPermission intelligentProcessData(SysPermission permission) {
        if (permission == null) {
            return null;
        }
        if (oConvertUtils.isEmpty(permission.getPermTag())) {
            String path = permission.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            permission.setPermTag(path);
        }else {
            String tag = permission.getPermTag();
            if (tag.startsWith("/")) {
                tag = tag.substring(1);
            }
            permission.setPermTag(tag);
        }
        // 组件
        if (oConvertUtils.isNotEmpty(permission.getComponent())) {
            String component = permission.getComponent();
//            if (component.startsWith("/")) {
//                component = component.substring(1);
//            }
            if (component.startsWith("/views")) {
                component = component.replaceFirst("/views", "");
            }
            if (component.startsWith("/src/views")) {
                component = component.replaceFirst("/src/views", "");
            }
            if (component.endsWith(".vue")) {
                component = component.replace(".vue", "");
            }
            permission.setComponent(component);
        }

        // 请求URL
        if (oConvertUtils.isNotEmpty(permission.getPath())) {
            String url = permission.getPath();
            if (url.endsWith(".vue")) {
                url = url.replace(".vue", "");
            }
            if (!url.startsWith("http") && !url.startsWith("/")&&!url.trim().startsWith("{{")) {
                url = "/" + url;
            }
            permission.setPath(url);
        }

//        // 一级菜单默认组件
//        if (0 == permission.getType() && oConvertUtils.isEmpty(permission.getComponent())) {
//            // 一级菜单默认组件
//            permission.setComponent("layouts/RouteView");
//        }
        return permission;
    }

}
