package com.oauth.system.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.oauth.system.service.ISysRolePermissionService;
import com.framework.core.excel.listener.AuthExcelModelListener;
import com.framework.core.excel.util.EasyExcelUtils;
import com.oauth.system.QueryWrapperGenerator;
import com.oauth.system.entity.SysRole;
import com.oauth.system.entity.SysRolePermission;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
public class SysTestController {
    @Autowired
    ISysRolePermissionService permissionService;
    static String K3CloudURL = "http://116.62.129.2/k3cloud/";
    static String dbId = "5b39dffef11ed4";
    static String uid = "administrator";
    static String pwd = "4009965012@lwkb";
    static int lang = 2052;
//    @RequestMapping(value = "/test", method = RequestMethod.POST)
    @ResponseBody
    public void testImport(@RequestParam("file") MultipartFile multipartFile){

        try{
            AuthExcelModelListener authExcelModelListener = new AuthExcelModelListener<SysRolePermission>(permissionService);

            EasyExcel.read(multipartFile.getInputStream(),SysRolePermission.class,authExcelModelListener ).doReadAll();
            System.out.println(authExcelModelListener.getCachedDataList());
        }catch (Exception e){

        }
        return ;
    }
        @GetMapping("/test")
    public Object set(HttpServletRequest request, HttpServletResponse response) {
            String pageNo = request.getParameter("pageNo");
            Map<String, String[]> parameterMap = request.getParameterMap();
            System.out.println(pageNo);
                QueryWrapper<SysRole> queryWrapper = QueryWrapperGenerator.initQueryWrapper(new SysRole(), request);


        return "s";
    }

//    @GetMapping("/test")
    public void doExport(HttpServletResponse response) throws IOException {
        try {
            //获取数据
            List<SysRolePermission> data = permissionService.list();
            if (CollectionUtils.isEmpty(data)) {
                data.add(new SysRolePermission());
            }
            //attachment指定独立文件下载  不指定则回浏览器中直接打开
            String fileName = "业务订单导出_" + DateUtil.formatDate(new Date());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            //导出excel

            EasyExcelUtils.exportByExcel(response, data, fileName, SysRolePermission.class);
            log.info("业务订单导出end");
        } catch (Exception e) {
            log.error("业务订单导出异常打印:", e);
        } finally {
            try {
                response.flushBuffer();
            } catch (IOException e) {
                log.error("业务订单导出输出流关闭失败: {}", e);
            }
        }


    }

    //    @RequestMapping(value = "/test")
    public void exportExcel(HttpServletRequest httpServletRequest, HttpServletResponse response) {
        AuthExcelModelListener authExcelModelListener = new AuthExcelModelListener<SysRolePermission>(permissionService);
        //excel的名称
        String fileName = "C:\\Users\\DELL\\Desktop\\业务订单导出_2022-04-24 (3).xlsx";
        EasyExcel.read(fileName,SysRolePermission.class,authExcelModelListener ).doReadAll();
        System.out.println(authExcelModelListener.getCachedDataList());
    }


}
