package com.oauth.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.oauth.system.entity.SysRole;
import com.oauth.system.mapper.SysRoleMapper;
import com.oauth.system.service.ISysRoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.util.ArrayList;
import java.util.List;

@Service
public class SysRoleServiceImpl extends ServiceImpl<SysRoleMapper, SysRole> implements ISysRoleService {
    @Override
    public List<SysRole> selectInIds(List<Integer> ids) {
        if (null == ids || 0 == ids.size()) {
            return new ArrayList<>();
        }
        QueryWrapper<SysRole> roleQueryWrapper = new QueryWrapper<>();
        roleQueryWrapper.in("id", ids);
        List<SysRole> roles = this.getBaseMapper().selectList(roleQueryWrapper);//
//        List<Role> roles = this.getBaseMapper().selectBatchIds(ids);
        return roles;
    }

    @Override
    public List<SysRole> selectByUserId(Integer userId) {
        List<SysRole> roles = this.getBaseMapper().selectByUserId(userId);
        return roles;
    }

    @Override
    public List<String> selectRoleByUserId(Long userId) {
        List<String> roles = this.getBaseMapper().selectRoleByUserId(userId);
        return roles;
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean deleteRole(String roleid) {
        //1.删除角色和用户关系
        this.baseMapper.deleteRoleUserRelation(roleid);
        //2.删除角色和权限关系
        this.baseMapper.deleteRolePermissionRelation(roleid);
        //3.删除角色
        this.removeById(roleid);
        return true;
    }
}