package com.oauth.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

import java.util.Arrays;

//
@Configuration
@EnableResourceServer
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class ResourceServerConfig extends ResourceServerConfigurerAdapter {
    private static final String DEMO_RESOURCE_ID = "auth-resource";
//    @Autowired
//    private TokenStore jwtTokenStore;
//    @Autowired
//    private JwtAccessTokenConverter jwtAccessTokenConverter;
//    @Bean
//    public ResourceServerTokenServices tokenService() {
//        DefaultTokenServices service = new DefaultTokenServices();
//
//        service.setTokenStore(jwtTokenStore);//令牌存储策略
//
////        service.setTokenEnhancer(jwtAccessTokenConverter);
//        return service;
//    }

//    @Override
//    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
//        resources.tokenStore(jwtTokenStore)
//                .resourceId(DEMO_RESOURCE_ID).tokenServices(tokenService());
//    }

    @Override
    public void configure(HttpSecurity http) throws Exception {

        http
                .authorizeRequests()
//                .antMatchers(FeignInsideAuthConfig.FEIGN_INSIDE_URL_PREFIX+"/**").permitAll()
                .antMatchers("/auth/login").permitAll()//登录接口
                .antMatchers("/auth/getCaptcha").permitAll()
                .antMatchers("/user/image").permitAll()
                .antMatchers("/swagger-ui.html","/webjars/**","/swagger-resources/**","/v2/**","doc.html","/").permitAll()
                .antMatchers("/test").permitAll()
                .antMatchers("/webSocketApi/**").permitAll()
                .antMatchers("/websocket/**").permitAll()
                .anyRequest().authenticated()
//                .antMatchers("/**").access("#oauth2.hasScope('ROLE_ADMIN')")
                .and().csrf().disable()
                .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }
}