package com.oauth.system.vo;

import com.oauth.system.entity.SysPermission;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
public class MenuPage {
    private String path;
    private String component;
//    private Boolean alwaysShow;
    private String name;
    private MenuMeta meta;

    private List<MenuPage> children = new ArrayList<>();

    public MenuPage(SysPermission permission, List<String> metaRoles) {
        this.path = permission.getPath();
        this.component = permission.getComponent();
//        this.alwaysShow = permission.getAlwaysShow();
        this.name = permission.getPermTag();
        this.meta = new MenuMeta(permission, metaRoles);
    }
}
