/*
SQLyog Enterprise v13.1.1 (64 bit)
MySQL - 8.0.26 : Database - db_nzwz
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`db_nzwz` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `db_nzwz`;

/*Table structure for table `qrtz_blob_triggers` */

DROP TABLE IF EXISTS `qrtz_blob_triggers`;

CREATE TABLE `qrtz_blob_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_blob_triggers` */

/*Table structure for table `qrtz_calendars` */

DROP TABLE IF EXISTS `qrtz_calendars`;

CREATE TABLE `qrtz_calendars` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_calendars` */

/*Table structure for table `qrtz_cron_triggers` */

DROP TABLE IF EXISTS `qrtz_cron_triggers`;

CREATE TABLE `qrtz_cron_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `CRON_EXPRESSION` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TIME_ZONE_ID` varchar(80) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_cron_triggers` */

insert  into `qrtz_cron_triggers`(`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`CRON_EXPRESSION`,`TIME_ZONE_ID`) values 
('DefaultQuartzScheduler','com.nzwz.quartz.job.SynchronizationJob','DEFAULT','0 */1 * * * ?','Asia/Shanghai');

/*Table structure for table `qrtz_fired_triggers` */

DROP TABLE IF EXISTS `qrtz_fired_triggers`;

CREATE TABLE `qrtz_fired_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `ENTRY_ID` varchar(95) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `FIRED_TIME` bigint(13) NOT NULL,
  `SCHED_TIME` bigint(13) NOT NULL,
  `PRIORITY` int(11) NOT NULL,
  `STATE` varchar(16) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_fired_triggers` */

insert  into `qrtz_fired_triggers`(`SCHED_NAME`,`ENTRY_ID`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`INSTANCE_NAME`,`FIRED_TIME`,`SCHED_TIME`,`PRIORITY`,`STATE`,`JOB_NAME`,`JOB_GROUP`,`IS_NONCONCURRENT`,`REQUESTS_RECOVERY`) values 
('DefaultQuartzScheduler','LAPTOP-L53FL4S316553427925651655342792554','com.nzwz.quartz.job.SynchronizationJob','DEFAULT','LAPTOP-L53FL4S31655342792565',1655342793391,1655342820000,5,'ACQUIRED',NULL,NULL,'0','0');

/*Table structure for table `qrtz_job_details` */

DROP TABLE IF EXISTS `qrtz_job_details`;

CREATE TABLE `qrtz_job_details` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) COLLATE utf8mb4_bin NOT NULL,
  `IS_DURABLE` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `IS_NONCONCURRENT` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `IS_UPDATE_DATA` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_job_details` */

insert  into `qrtz_job_details`(`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`,`DESCRIPTION`,`JOB_CLASS_NAME`,`IS_DURABLE`,`IS_NONCONCURRENT`,`IS_UPDATE_DATA`,`REQUESTS_RECOVERY`,`JOB_DATA`) values 
('DefaultQuartzScheduler','com.nzwz.quartz.job.SynchronizationJob','DEFAULT',NULL,'com.nzwz.quartz.job.SynchronizationJob','0','0','0','0',0xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c77080000001000000001740009706172616d657465727400007800);

/*Table structure for table `qrtz_locks` */

DROP TABLE IF EXISTS `qrtz_locks`;

CREATE TABLE `qrtz_locks` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `LOCK_NAME` varchar(40) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_locks` */

insert  into `qrtz_locks`(`SCHED_NAME`,`LOCK_NAME`) values 
('DefaultQuartzScheduler','STATE_ACCESS'),
('DefaultQuartzScheduler','TRIGGER_ACCESS');

/*Table structure for table `qrtz_paused_trigger_grps` */

DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;

CREATE TABLE `qrtz_paused_trigger_grps` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_paused_trigger_grps` */

/*Table structure for table `qrtz_scheduler_state` */

DROP TABLE IF EXISTS `qrtz_scheduler_state`;

CREATE TABLE `qrtz_scheduler_state` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL,
  `CHECKIN_INTERVAL` bigint(13) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_scheduler_state` */

insert  into `qrtz_scheduler_state`(`SCHED_NAME`,`INSTANCE_NAME`,`LAST_CHECKIN_TIME`,`CHECKIN_INTERVAL`) values 
('DefaultQuartzScheduler','LAPTOP-L53FL4S31655342792565',1655342793307,10000);

/*Table structure for table `qrtz_simple_triggers` */

DROP TABLE IF EXISTS `qrtz_simple_triggers`;

CREATE TABLE `qrtz_simple_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `REPEAT_COUNT` bigint(7) NOT NULL,
  `REPEAT_INTERVAL` bigint(12) NOT NULL,
  `TIMES_TRIGGERED` bigint(10) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simple_triggers` */

/*Table structure for table `qrtz_simprop_triggers` */

DROP TABLE IF EXISTS `qrtz_simprop_triggers`;

CREATE TABLE `qrtz_simprop_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `STR_PROP_1` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_2` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_3` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `INT_PROP_1` int(11) DEFAULT NULL,
  `INT_PROP_2` int(11) DEFAULT NULL,
  `LONG_PROP_1` bigint(20) DEFAULT NULL,
  `LONG_PROP_2` bigint(20) DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simprop_triggers` */

/*Table structure for table `qrtz_triggers` */

DROP TABLE IF EXISTS `qrtz_triggers`;

CREATE TABLE `qrtz_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) COLLATE utf8mb4_bin DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PREV_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PRIORITY` int(11) DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_TYPE` varchar(8) COLLATE utf8mb4_bin NOT NULL,
  `START_TIME` bigint(13) NOT NULL,
  `END_TIME` bigint(13) DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `MISFIRE_INSTR` smallint(2) DEFAULT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_triggers` */

insert  into `qrtz_triggers`(`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`JOB_NAME`,`JOB_GROUP`,`DESCRIPTION`,`NEXT_FIRE_TIME`,`PREV_FIRE_TIME`,`PRIORITY`,`TRIGGER_STATE`,`TRIGGER_TYPE`,`START_TIME`,`END_TIME`,`CALENDAR_NAME`,`MISFIRE_INSTR`,`JOB_DATA`) values 
('DefaultQuartzScheduler','com.nzwz.quartz.job.SynchronizationJob','DEFAULT','com.nzwz.quartz.job.SynchronizationJob','DEFAULT',NULL,1655342820000,1655342793337,5,'ACQUIRED','CRON',1655176229000,0,NULL,0,'');

/*Table structure for table `t_schedule_trigger` */

DROP TABLE IF EXISTS `t_schedule_trigger`;

CREATE TABLE `t_schedule_trigger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cron` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `status` char(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `job_name` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `job_group` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `job_name` (`job_name`,`job_group`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger` */

/*Table structure for table `oauth_client_details` */

DROP TABLE IF EXISTS `oauth_client_details`;

CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `oauth_client_details` */

insert  into `oauth_client_details`(`client_id`,`resource_ids`,`client_secret`,`scope`,`authorized_grant_types`,`web_server_redirect_uri`,`authorities`,`access_token_validity`,`refresh_token_validity`,`additional_information`,`autoapprove`) values 
('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),
('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,3600,36000,NULL,'1'),
('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,7200,36000,NULL,'1');

/*Table structure for table `sys_depart` */

DROP TABLE IF EXISTS `sys_depart`;

CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';

/*Data for the table `sys_depart` */

/*Table structure for table `sys_fill_rule` */

DROP TABLE IF EXISTS `sys_fill_rule`;

CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_fill_rule` */

insert  into `sys_fill_rule`(`id`,`rule_name`,`rule_code`,`rule_class`,`rule_params`,`update_by`,`update_time`,`create_by`,`create_time`) values 
('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单key',
  `path` varchar(258) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '路径',
  `component` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '组件',
  `title` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`fsort`,`type`,`perm_tag`,`path`,`component`,`title`,`icon`,`parent_id`,`is_leaf`,`sort_no`,`fremarks`,`fstatus`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,0,2,'showMember','/showMember','','查询用户','',0,1,1.00,'','','2022-04-12 15:35:43','','2022-03-31 17:21:29',''),
(2,0,2,'addMember','/addMember','','添加用户','',0,1,1.00,'','','2022-04-12 15:35:45','','2022-03-31 17:21:29',''),
(3,0,2,'updateMember','/updateMember','','修改用户','',0,1,1.00,'','','2022-04-12 15:35:46','','2022-03-31 17:21:29',''),
(4,0,2,'delMember','/delMember','','删除用户','',0,1,1.00,'','','2022-04-12 15:35:48','','2022-03-31 17:21:29',''),
(12,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-06-14 14:18:37','','2022-03-31 17:21:29',''),
(20,0,1,'tableCreator','/tableCreator','/system/tableCreator','表单生成','',12,1,1.00,'','','2022-05-11 10:51:13','','2022-03-31 17:21:29',''),
(21,0,1,'menu','/menu','/system/menuManage','菜单管理','',12,1,2.00,'','','2022-05-05 10:19:35','','2022-03-31 18:19:39',''),
(22,0,1,'role','/role','/system/roleManage','角色管理','',12,1,3.00,'','','2022-04-12 15:35:59','','2022-04-02 17:16:42',''),
(23,0,1,'user','/user','/system/userManage','用户管理','',12,1,4.00,'','','2022-04-18 10:51:45','','2022-04-15 10:45:07',''),
(29,0,1,'test','/test','/system/test','测试页面','',12,1,5.00,'','','2022-04-26 14:51:54','','2022-04-18 16:56:10',''),
(32,0,1,'system/departmentManage','/departmentManage','/system/departmentManage','部门管理','',12,1,6.00,'','','2022-04-22 10:50:07','','2022-04-22 10:25:33',''),
(33,0,0,'project','/project','Layout','项目管理','Folder',0,0,2.00,'','','2022-04-22 11:39:26','','2022-04-22 11:32:52',''),
(34,0,1,'projectMaster','/projectMaster','/project/projectMaster','项目模版','',33,1,1.00,'','','2022-06-09 17:13:49','','2022-04-22 11:39:26',''),
(35,0,1,'teamList','/teamList','/project/teamList','团队列表','',33,1,2.00,'','','2022-04-22 11:59:07','','2022-04-22 11:58:35',''),
(36,0,0,'workingTime','/workingTime','Layout','工时中心','Clock',0,1,3.00,'','','2022-06-14 14:09:32','','2022-05-05 10:17:26',''),
(37,0,0,'developmentCenter','/developmentCenter','Layout','开发中心','Cloudy',0,1,4.00,'','','2022-05-05 10:21:40','','2022-05-05 10:21:40',''),
(38,0,0,'testManage','/testManage','Layout','测试管理','Checked',0,1,5.00,'','','2022-05-05 10:23:06','','2022-05-05 10:23:06',''),
(39,0,0,'businessManage','/businessManage','Layout','商务管理','Shop',0,1,6.00,'','','2022-05-05 10:26:45','','2022-05-05 10:26:45',''),
(40,0,0,'teamManage','/teamManage','Layout','团队管理','User',0,1,7.00,'','','2022-05-05 10:31:47','','2022-05-05 10:31:47',''),
(41,0,0,'ReviewManage','/ReviewManage','Layout','评审管理','Edit',0,1,8.00,'','','2022-05-05 10:35:14','','2022-05-05 10:35:14',''),
(42,0,0,'formManage','/formManage','Layout','报表','Tickets',0,1,9.00,'','','2022-05-05 10:37:25','','2022-05-05 10:37:20',''),
(43,0,0,'processDesign','/processDesign','Layout','流程设计','Tickets',0,1,10.00,'','','2022-05-05 10:39:32','','2022-05-05 10:39:32',''),
(45,0,0,'tableEntity','/tableEntity','Layout','完成表单','Tickets',0,1,3.00,'','','2022-05-31 15:12:19','','2022-05-16 11:53:09',''),
(57,NULL,1,'departmentManage','/departmentManage','Layout','部门维护','',57,0,0.00,'','1','2022-06-08 20:56:25','','2022-06-08 20:54:59',''),
(58,NULL,0,'department','/department','Layout','部门','User',0,0,0.00,'','1','2022-06-09 10:25:06','','2022-06-08 20:58:42',''),
(59,NULL,1,'departmentIndex','/departmentIndex','/department/departmentManage','部门列表','',58,1,0.00,'','1','2022-06-09 10:34:40','','2022-06-08 20:59:44',''),
(60,NULL,1,'bizunit','/bizunit','/department/bizunit','事业部','',58,1,0.00,'','1','2022-06-09 15:25:43','','2022-06-09 15:25:43',''),
(61,NULL,1,'projectType','/projectType','/project/projectType','项目类型','',33,1,0.00,'','1','2022-06-09 16:33:26','','2022-06-09 16:33:26','');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `role_Desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`role_code`,`role_Name`,`role_Desc`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29',''),
(2,'add_user','添加管理员','添加管理员','2022-04-21 11:33:05','admin','2022-03-31 17:21:29',''),
(3,'manage','管理','管理','2022-04-21 11:34:49','admin','2022-03-31 17:21:29',''),
(4,'dept','部门','部门','2022-04-21 11:34:54','admin','2022-03-31 17:21:29',''),
(5,'user','用户','用户1','2022-06-14 14:13:21','admin','2022-03-31 17:21:29',''),
(6,'role','角色','角色','2022-04-21 11:35:05','admin','2022-03-31 17:21:29',''),
(7,'menu','权限','权限','2022-04-21 11:35:09','admin','2022-03-31 17:21:29',''),
(8,'test','测试','测试','2022-04-21 11:35:14','admin','2022-03-31 17:21:29',''),
(11,'人事','人事','负责招聘','2022-05-26 15:22:00','admin','2022-05-26 14:44:21','admin'),
(12,'test001','测试','测试','2022-06-02 23:42:59','admin','2022-06-02 23:34:23','admin'),
(14,'nulltest','空测试','没有权限的测试','2022-06-07 09:53:51','','2022-06-07 09:53:51','admin');

/*Table structure for table `sys_role_permission` */

DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`role_id`,`perm_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(44,1,12,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(45,1,20,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(46,1,21,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(47,1,22,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(48,1,23,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(49,1,29,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(50,1,32,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(52,1,34,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(53,1,35,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(54,2,2,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(55,8,12,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(56,8,20,'2022-04-25 14:51:05','','2022-04-25 14:51:05',''),
(72,8,38,'2022-05-17 16:38:44','','2022-05-17 16:38:44',''),
(73,11,23,'2022-05-26 14:44:46','','2022-05-26 14:44:46',''),
(74,8,23,'2022-05-26 14:55:29','','2022-05-26 14:55:29',''),
(86,5,22,'2022-05-26 15:51:23','','2022-05-26 15:51:23',''),
(88,5,12,'2022-05-26 15:52:56','','2022-05-26 15:52:56',''),
(89,1,33,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(90,1,36,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(91,1,37,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(92,1,38,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(93,1,39,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(94,1,40,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(95,1,41,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(96,1,42,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(97,1,43,'2022-05-26 15:56:32','','2022-05-26 15:56:32',''),
(98,5,23,'2022-05-26 16:20:11','','2022-05-26 16:20:11',''),
(99,1,45,'2022-05-29 09:26:20','','2022-05-29 09:26:20',''),
(100,12,33,'2022-06-02 23:34:55','','2022-06-02 23:34:55',''),
(101,12,34,'2022-06-02 23:34:55','','2022-06-02 23:34:55',''),
(102,12,35,'2022-06-02 23:34:55','','2022-06-02 23:34:55',''),
(103,12,12,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(104,12,20,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(105,12,21,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(106,12,22,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(109,12,32,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(111,12,36,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(112,12,45,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(113,12,37,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(114,12,38,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(115,12,39,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(116,12,40,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(117,12,41,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(118,12,42,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(119,12,43,'2022-06-02 23:43:23','','2022-06-02 23:43:23',''),
(121,1,58,'2022-06-09 10:23:55','','2022-06-09 10:23:55',''),
(122,1,59,'2022-06-09 10:26:12','','2022-06-09 10:26:12',''),
(123,1,60,'2022-06-09 15:26:13','','2022-06-09 15:26:13',''),
(124,1,61,'2022-06-09 16:33:38','','2022-06-09 16:33:38',''),
(125,7,33,'2022-06-14 14:13:03','','2022-06-14 14:13:03',''),
(126,7,61,'2022-06-14 14:13:03','','2022-06-14 14:13:03',''),
(127,7,34,'2022-06-14 14:13:03','','2022-06-14 14:13:03',''),
(128,7,35,'2022-06-14 14:13:03','','2022-06-14 14:13:03',''),
(129,8,58,'2022-06-14 14:16:23','','2022-06-14 14:16:23',''),
(130,8,60,'2022-06-14 14:16:23','','2022-06-14 14:16:23',''),
(131,8,59,'2022-06-14 14:16:23','','2022-06-14 14:16:23','');

/*Table structure for table `sys_sms` */

DROP TABLE IF EXISTS `sys_sms`;

CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms` */

/*Table structure for table `sys_sms_template` */

DROP TABLE IF EXISTS `sys_sms_template`;

CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms_template` */

insert  into `sys_sms_template`(`id`,`template_name`,`template_code`,`template_type`,`template_content`,`template_test_json`,`create_time`,`create_by`,`update_time`,`update_by`) values 
('1','系统消息通知','sys_ts_note','4','<h1>&nbsp; &nbsp; 系统通知</h1>\n<ul>\n<li>通知时间：&nbsp; ${ts_date}</li>\n<li>通知内容：&nbsp; ${ts_content}</li>\n</ul>',NULL,'2019-11-27 16:30:27','admin','2019-11-27 19:36:50','admin'),
('2','流程催办','bpm_cuiban','4','<h1>&nbsp; &nbsp;流程催办提醒</h1>\n<ul>\n<li>流程名称：&nbsp; ${bpm_name}</li>\n<li>催办任务：&nbsp; ${bpm_task}</li>\n<li>催办时间 :&nbsp; &nbsp; ${datetime}</li>\n<li>催办内容 :&nbsp; &nbsp; ${remark}</li>\n</ul>',NULL,'2019-11-27 17:08:12','admin','2019-11-27 19:36:45','admin'),
('3','流程办理超时提醒','bpm_chaoshi_tip','4','<h1>&nbsp; &nbsp;流程办理超时提醒</h1>\n<ul>\n<li>&nbsp; &nbsp;超时提醒信息：&nbsp; &nbsp; 您有待处理的超时任务，请尽快处理！</li>\n<li>&nbsp; &nbsp;超时任务标题：&nbsp; &nbsp; ${title}</li>\n<li>&nbsp; &nbsp;超时任务节点：&nbsp; &nbsp; ${task}</li>\n<li>&nbsp; &nbsp;任务处理人：&nbsp; &nbsp; &nbsp; &nbsp;${user}</li>\n<li>&nbsp; &nbsp;任务开始时间：&nbsp; &nbsp; ${time}</li>\n</ul>',NULL,'2019-11-27 19:19:24','admin','2019-11-27 19:36:37','admin'),
('4','请维护下商品单价','11111','4','<p>请帮忙维护下商品单价</p>',NULL,'2020-11-18 17:18:58','admin','2020-11-18 17:20:18','admin'),
('5','催办：${taskName}','SYS001','3','${userName}，您好！\r\n请前待办任务办理事项！${taskName}\r\n\r\n\r\n===========================\r\n此消息由系统发出','{\r\n\"taskName\":\"HR审批\",\r\n\"userName\":\"admin\"\r\n}','2018-07-05 14:46:18','admin','2018-07-05 18:31:34','admin');

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '账号',
  `realname` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '真名',
  `password` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int DEFAULT '0',
  `account_Non_Expired` int DEFAULT '0',
  `account_Non_Locked` int DEFAULT '0',
  `credentials_Non_Expired` int DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`username`,`realname`,`password`,`create_Date`,`last_Login_Time`,`enabled`,`account_Non_Expired`,`account_Non_Locked`,`credentials_Non_Expired`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','张三','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29',''),
(2,'admin_add','小余','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2018-11-13',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29',''),
(71,'administrator','','$2a$10$Zf2K/XL/Qc1bM..JAummnuKLW1wcMPj6xK9FD5zqi0pzCs2Ldh0v.','2022-05-26 16:08:44',NULL,0,0,0,0,'2022-05-26 16:08:44','','2022-05-26 16:08:44',''),
(73,'Allen','','$2a$10$Ej5cJKOkrvspUArfNwyU5OZjajKQ70.U/1y4EuXIGLNIcyY76RELS','2022-05-26 16:32:04',NULL,0,0,0,0,'2022-05-26 16:32:04','','2022-05-26 16:32:04',''),
(75,'lnztest','','$2a$10$MMX.fgDxIAf8c7Ry7844wO429Ifnri08DujD8urDltIheLUk.8juy','2022-06-07 09:09:13',NULL,0,0,0,0,'2022-06-07 09:09:13','','2022-06-07 09:09:13',''),
(77,'text','','$2a$10$KWj14tEVr4I6MeYTh6nZw.HpZ8Ep8.uBBXnanHcF42qw6RRoX/8mC','2022-06-08 15:55:11',NULL,0,0,0,0,'2022-06-08 15:55:11','','2022-06-08 15:55:11','');

/*Table structure for table `sys_user_depart` */

DROP TABLE IF EXISTS `sys_user_depart`;

CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_user_depart` */

/*Table structure for table `sys_user_message` */

DROP TABLE IF EXISTS `sys_user_message`;

CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `sys_user_message` */

insert  into `sys_user_message`(`user_id`,`name`,`avatar`,`introduction`,`fauth_account`,`fenglish_name`,`fwork_no`,`fdept`,`fphone`,`fmail`,`fwork_addr`,`fposition`,`finduction_date`,`fstate`,`fdate`,`fcreator`) values 
(1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00',''),
(2,'小余','http://159.75.250.248:9000/images/1.jpg?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=RAW%2F20220607%2Fus-east-1%2Fs3%2Faws4_request&X-Amz-Date=20220607T032704Z&X-Amz-Expires=604800&X-Amz-SignedHeaders=host&X-Amz-Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71','积极','admin_add','ad','12318','测试','19807929047','12318','深圳','测试','2022-04-04 00:00:00','1','2022-04-02 00:00:00',''),
(71,'李四','http://159.75.250.248:9000/images/1.jpg?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=RAW%2F20220607%2Fus-east-1%2Fs3%2Faws4_request&X-Amz-Date=20220607T032704Z&X-Amz-Expires=604800&X-Amz-SignedHeaders=host&X-Amz-Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71','','administrator','','12318','','','','','hr','2022-05-26 00:00:00','0','2022-05-26 00:00:00',''),
(73,'12318','http://159.75.250.248:9000/images/1.jpg?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=RAW%2F20220607%2Fus-east-1%2Fs3%2Faws4_request&X-Amz-Date=20220607T032704Z&X-Amz-Expires=604800&X-Amz-SignedHeaders=host&X-Amz-Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71','','Allen','','','','','','','',NULL,'0','2022-05-26 00:00:00',''),
(75,'lnztest','http://159.75.250.248:9000/images/1.jpg?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=RAW%2F20220607%2Fus-east-1%2Fs3%2Faws4_request&X-Amz-Date=20220607T032704Z&X-Amz-Expires=604800&X-Amz-SignedHeaders=host&X-Amz-Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71','','lnztest','','MB-001','','','','','',NULL,'0','2022-06-07 00:00:00',''),
(77,'123456','Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71','','text','','','','','','','',NULL,'1','2022-06-08 00:00:00','');

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `user_id` bigint DEFAULT NULL,
  `role_id` bigint DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(71,5,'2022-05-26 16:24:04','','2022-05-26 16:24:04',''),
(2,8,'2022-05-26 16:25:29','','2022-05-26 16:25:29',''),
(75,14,'2022-06-07 17:45:03','','2022-06-07 17:45:03',''),
(1,3,'2022-06-08 14:22:02','','2022-06-08 14:22:02',''),
(1,1,'2022-06-08 14:22:02','','2022-06-08 14:22:02',''),
(1,2,'2022-06-08 14:22:02','','2022-06-08 14:22:02',''),
(77,1,'2022-06-14 14:12:23','','2022-06-14 14:12:23',''),
(77,3,'2022-06-14 14:12:23','','2022-06-14 14:12:23','');

/*Table structure for table `undo_log` */

DROP TABLE IF EXISTS `undo_log`;

CREATE TABLE `undo_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` bigint NOT NULL,
  `xid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `context` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int NOT NULL,
  `log_created` datetime NOT NULL,
  `log_modified` datetime NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `undo_log` */

/*Table structure for table `t_schedule_trigger_param` */

DROP TABLE IF EXISTS `t_schedule_trigger_param`;

CREATE TABLE `t_schedule_trigger_param` (
  `param_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `schedule_trigger_id` int(11) NOT NULL,
  PRIMARY KEY (`param_id`) USING BTREE,
  KEY `schedule_trigger_id` (`schedule_trigger_id`) USING BTREE,
  CONSTRAINT `t_schedule_trigger_param_ibfk_1` FOREIGN KEY (`schedule_trigger_id`) REFERENCES `t_schedule_trigger` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger_param` */

/*Table structure for table `tb_init_connect_parm` */

DROP TABLE IF EXISTS `tb_init_connect_parm`;

CREATE TABLE `tb_init_connect_parm` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `k3_cloud_url` varchar(64) DEFAULT NULL COMMENT '金蝶地址',
  `dbid` varchar(64) DEFAULT NULL COMMENT '金蝶账套',
  `uid` varchar(64) DEFAULT NULL COMMENT '用户名',
  `pwd` varchar(64) DEFAULT NULL COMMENT '密码',
  `lang` int(11) DEFAULT NULL COMMENT '端口',
  `is_auto_submit` tinyint(1) DEFAULT '1' COMMENT '是否提交审核',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶配置表';

/*Data for the table `tb_init_connect_parm` */

insert  into `tb_init_connect_parm`(`id`,`k3_cloud_url`,`dbid`,`uid`,`pwd`,`lang`,`is_auto_submit`) values 
(1,'http://192.168.2.66/k3cloud/','61b6b0d355f475','Administrator','888888',2052,1);

/*Table structure for table `tb_log` */

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) DEFAULT '' COMMENT '名称',
  `content` varchar(128) DEFAULT '' COMMENT '内容',
  `data` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '0' COMMENT '同步状态（0-同步失败，1-同步成功）',
  `message` longtext COMMENT '错误原因',
  `costime` int(11) DEFAULT '0' COMMENT '同步时长',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='日志记录表';

/*Data for the table `tb_log` */

/*Table structure for table `tb_quartz_job` */

DROP TABLE IF EXISTS `tb_quartz_job`;

CREATE TABLE `tb_quartz_job` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `job_class_name` varchar(255) DEFAULT NULL COMMENT '任务类名',
  `cron_expression` varchar(255) DEFAULT NULL COMMENT 'cron表达式',
  `parameter` varchar(255) DEFAULT NULL COMMENT '参数',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态（0-关闭 1-启动）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='定时任务表';

/*Data for the table `tb_quartz_job` */

insert  into `tb_quartz_job`(`id`,`job_class_name`,`cron_expression`,`parameter`,`description`,`status`) values 
(1,'com.nzwz.quartz.job.SynchronizationJob','0 */1 * * * ?','','同步定时任务',0);

/*Table structure for table `tb_table_relation` */

DROP TABLE IF EXISTS `tb_table_relation`;

CREATE TABLE `tb_table_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `table_name` varchar(128) DEFAULT '' COMMENT '表名称',
  `table_header` varchar(128) DEFAULT '' COMMENT '表头',
  `table_date` varchar(128) DEFAULT '' COMMENT '表头日期',
  `sub_table_header` varchar(128) DEFAULT '' COMMENT '表体的表头',
  `primary_key` varchar(128) DEFAULT '' COMMENT '主键',
  `foreign_key` varchar(128) DEFAULT '' COMMENT '外键',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='表关系记录表';

/*Data for the table `tb_table_relation` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
