package com.oauth.system.controller;

import com.framework.core.response.StarBosResult;
import com.oauth.system.entity.SysUserAccount;
import com.oauth.system.service.ISysRoleService;
import com.oauth.system.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "用户账号管理")
@RestController
@Slf4j
@RequestMapping("userAccount")
public class SysUserAccountController {

    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysUserService userService;

    @GetMapping("findRoleByUser")
    @ApiOperation(value = "userAccount-查询账号角色", notes = "userAccount-查询账号角色")
    public StarBosResult<List<String>> findRoleByUser(@RequestParam(name = "userId") Long userId) {
        StarBosResult<List<String>> result = new StarBosResult<>();
        SysUserAccount byId = userService.getById(userId);
        if (byId == null) {
            result.error500("未找到对应实体");
        } else {
            List<String> maps = roleService.selectRoleByUserId(userId);
            System.out.println(maps);
            result.successOk(maps);
        }
        return result;
    }
}
