/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webapi.sdk;

import com.kingdee.bos.webapi.entity.Cookie;
import com.kingdee.bos.webapi.entity.RequestBodyObject;
import com.kingdee.bos.webapi.utils.HttpUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpRequester {
    int connectTimeout = 120;
    RequestBodyObject reqJson;
    int requestTimeout = 120;
    String url;
    Map<String, String> header;
    int statusCode;
    Set<Cookie> repoCookies;

    public HttpRequester(String url, Map<String, String> header, RequestBodyObject reqJson) {
        this.url = url;
        this.header = header;
        this.reqJson = reqJson;
    }

    public HttpRequester(String url, Map<String, String> header, RequestBodyObject reqJson, int connectTimeout, int requestTimeout) {
        this.url = url;
        this.header = header;
        this.reqJson = reqJson;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
    }

    public String post() throws Exception {
        String result;
        block12: {
            PrintWriter out = null;
            result = "";
            URL realUrl = new URL(this.url);
            HttpURLConnection conn = null;
            Proxy proxy = HttpUtils.getProxy();
            conn = proxy != null ? (HttpURLConnection)realUrl.openConnection(proxy) : (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(this.getConnectTimeout() * 1000);
            conn.setReadTimeout(this.getRequestTimeout() * 1000);
            if (this.header != null) {
                for (Map.Entry<String, String> entry : this.header.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.setRequestProperty("Content-type", "applicatin/json");
            conn.setRequestProperty("User-Agent", "Kingdee/Java WebApi SDK 7.3 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            try {
                int statusCode;
                if (this.reqJson != null) {
                    out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), "utf8"));
                    out.print(this.reqJson.toJson());
                    out.flush();
                }
                if ((statusCode = conn.getResponseCode()) == 200 || statusCode == 206) {
                    for (Map.Entry<String, List<String>> cookie : conn.getHeaderFields().entrySet()) {
                        if (cookie.getKey() == null || !cookie.getKey().equals("Set-Cookie")) continue;
                        this.repoCookies = new HashSet<Cookie>();
                        for (String c : cookie.getValue()) {
                            Cookie ck = Cookie.parse(c);
                            if (ck == null) continue;
                            this.repoCookies.add(new Cookie(c));
                        }
                    }
                    result = this.readRepoBody(conn);
                    break block12;
                }
                result = this.readRepoBody(conn);
                throw new Exception(String.format("StatusCode:%s,\tDesc:%s", statusCode, result));
            }
            catch (Exception er) {
                throw er;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return result;
    }

    String readRepoBody(HttpURLConnection conn) throws UnsupportedEncodingException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf8"));
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        return sb.toString();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public RequestBodyObject getReqJson() {
        return this.reqJson;
    }

    public void setReqJson(RequestBodyObject reqJson) {
        this.reqJson = reqJson;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Set<Cookie> getRepoCookies() {
        return this.repoCookies;
    }

    public void setRepoCookies(Set<Cookie> repoCookies) {
        this.repoCookies = repoCookies;
    }
}

