package com.framework.core.exception;


import com.framework.core.response.StarBosResult;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/*每次增加异常，需要在日志切面类里面增加异常通知的异常类型，否则将无法记录接口发生异常的日志*/
@ControllerAdvice
public class GlobalExceptionHandler {

    /*金蝶云操作异常*/
    @ResponseBody
    @ExceptionHandler(MetaDataQueryException.class)
    public StarBosResult kingdeeException(HttpServletRequest req, MetaDataQueryException e)
    {
   /*     Result r=new Result();
        r.setResult(e.getResult());*/
        return StarBosResult.fail(e.getMessage());
    }

}
