package com.nzwz.controller;

import com.nzwz.common.response.RestResponse;
import com.nzwz.transfer.synchronization.AbnormalSynchronizationInVo;
import com.nzwz.transfer.synchronization.InitConnectParmCreateInVo;
import com.nzwz.transfer.synchronization.InitConnectParmOutVo;
import com.nzwz.serivce.ISynchronizationService;
import com.nzwz.transfer.synchronization.ManualSynchronizationInVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "自动同步")
@RestController
@RequestMapping("/api")
public class SynchronizationController {

    @Autowired
    private ISynchronizationService synchronizationService;


    @ApiOperation("开启自动同步")
    @GetMapping("/start/synchronization")
    public RestResponse startSynchronization() {
        return synchronizationService.startSynchronization();
    }

    @ApiOperation("关闭自动同步")
    @GetMapping("/turn/off/synchronization")
    public RestResponse turnOffSynchronization() {
        return synchronizationService.turnOffSynchronization();
    }

    @ApiOperation("查询金蝶参数")
    @GetMapping("/init/connect/param")
    public RestResponse initConnectParam() {
        InitConnectParmOutVo outVo = synchronizationService.initConnectParam();
        return RestResponse.success(outVo);
    }

    @ApiOperation("保存金蝶参数")
    @PostMapping("/init/connect/param/create")
    public RestResponse initConnectParamCreate(@RequestBody @Validated InitConnectParmCreateInVo inVo) {
        return synchronizationService.initConnectParamCreate(inVo);
    }

    @ApiOperation("手动启动同步方法")
    @PostMapping("/manual/synchronization")
    public RestResponse manualSynchronization(@RequestBody ManualSynchronizationInVo inVo) {
        return synchronizationService.manualSynchronization(inVo);
    }

    @ApiOperation("手动同步失败同步方法")
    @PostMapping("/abnormal/synchronization")
    public RestResponse abnormalSynchronization(@RequestBody AbnormalSynchronizationInVo inVo) {
        return synchronizationService.abnormalSynchronization(inVo);
    }


}
