package com.nzwz.serivce;

import com.nzwz.common.response.RestResponse;
import com.nzwz.transfer.synchronization.AbnormalSynchronizationInVo;
import com.nzwz.transfer.synchronization.InitConnectParmCreateInVo;
import com.nzwz.transfer.synchronization.InitConnectParmOutVo;
import com.nzwz.transfer.synchronization.ManualSynchronizationInVo;

import java.util.List;

/**
 * @author Inori
 */
public interface ISynchronizationService {

    /**
     * 开启同步
     *
     * @return 结果
     */
    RestResponse startSynchronization();

    /**
     * 关闭同步
     *
     * @return 结果
     */
    RestResponse turnOffSynchronization();

    /**
     * 查询金蝶配置
     *
     * @return 金蝶配置
     */
    InitConnectParmOutVo initConnectParam();

    /**
     * 保存金蝶配置
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse initConnectParamCreate(InitConnectParmCreateInVo inVo);

    /**
     * 手动启动同步方法
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse manualSynchronization(ManualSynchronizationInVo inVo);

    /**
     * 手动启动失败同步方法
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse abnormalSynchronization(AbnormalSynchronizationInVo inVo);

    /**
     * 同步方法
     *
     * @param tableHeaderList 表名
     */
    void synchronization(List<String> tableHeaderList);


}
