package com.nzwz.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public class KingDeeUtil {

    public static boolean isError(String json) {
        Map<String, Object> map = JsonUtil.toMap(json, String.class, Object.class);

        Map<String, Object> tempMap = JsonUtil.toMap(JsonUtil.toString(map.get("Result")), String.class, Object.class);

        Map<String, Object> responseMap = JsonUtil.toMap(JsonUtil.toString(tempMap.get("ResponseStatus")), String.class, Object.class);

        List<Object> errorList = JsonUtil.toList(JsonUtil.toString(responseMap.get("Errors")), Object.class);
        return !CollectionUtils.isEmpty(errorList);
    }

    public static String getMessage(Object object) {
        Map<String, Object> map = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

        String result = JsonUtil.toString(map.get("Result"));
        Map<String, Object> toMap = JsonUtil.toMap(result, String.class, Object.class);

        String responseStatus = JsonUtil.toString(toMap.get("ResponseStatus"));
        Map<String, Object> objectMap = JsonUtil.toMap(responseStatus, String.class, Object.class);

        List<Object> errorList = JsonUtil.toList(JsonUtil.toString(objectMap.get("Errors")), Object.class);
        StringBuilder message = new StringBuilder();
        for (Object obj : errorList) {
            Map<String, Object> messageMap = JsonUtil.toMap(JsonUtil.toString(obj), String.class, Object.class);
            if (StringUtils.isBlank(message)) {
                message.append(messageMap.get("Message").toString());
            } else {
                message.append(",").append(messageMap.get("Message").toString());
            }
        }

        return message.toString();
    }


}
