package com.system.framework.core.excel.util;

import com.alibaba.excel.EasyExcel;
import com.system.framework.core.excel.ExportModel;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;

public class ExcelUtil {


    public static void export(ExportModel exportModel, HttpServletResponse response) throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String fileName = URLEncoder.encode(exportModel.getName(), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write(response.getOutputStream()).autoCloseStream(Boolean.FALSE).head(exportModel.getHead()).sheet(exportModel.getName()).doWrite(exportModel.getDataList());
    }
}
