/*
SQLyog Enterprise v13.1.1 (64 bit)
MySQL - 5.7.25 : Database - db_robot
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`db_robot` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `db_robot`;

/*Table structure for table `oauth_client_details` */

DROP TABLE IF EXISTS `oauth_client_details`;

CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `oauth_client_details` */

insert  into `oauth_client_details`(`client_id`,`resource_ids`,`client_secret`,`scope`,`authorized_grant_types`,`web_server_redirect_uri`,`authorities`,`access_token_validity`,`refresh_token_validity`,`additional_information`,`autoapprove`) values 
('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),
('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,604800,604800,NULL,'1'),
('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,604800,604800,NULL,'1');

/*Table structure for table `sys_depart` */

DROP TABLE IF EXISTS `sys_depart`;

CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';

/*Data for the table `sys_depart` */

/*Table structure for table `sys_fill_rule` */

DROP TABLE IF EXISTS `sys_fill_rule`;

CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_fill_rule` */

insert  into `sys_fill_rule`(`id`,`rule_name`,`rule_code`,`rule_class`,`rule_params`,`update_by`,`update_time`,`create_by`,`create_time`) values 
('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) NOT NULL COMMENT '表单key',
  `path` varchar(258) NOT NULL COMMENT '路径',
  `component` varchar(64) DEFAULT '' COMMENT '组件',
  `title` varchar(32) NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`fsort`,`type`,`perm_tag`,`path`,`component`,`title`,`icon`,`parent_id`,`is_leaf`,`sort_no`,`fremarks`,`fstatus`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-08-01 09:50:54','','2022-03-31 17:21:29',''),
(2,0,1,'menu','/menu','/system/menuManage','菜单管理','',1,1,2.00,'','','2022-08-01 11:27:13','','2022-03-31 18:19:39',''),
(3,0,1,'role','/role','/system/roleManage','角色管理','',1,1,3.00,'','','2022-08-01 11:27:14','','2022-04-02 17:16:42',''),
(4,0,1,'user','/user','/system/userManage','用户管理','',1,1,4.00,'','','2022-08-08 09:47:47','','2022-04-15 10:45:07',''),
(6,NULL,1,'synchronization','/synchronization','/system/enableSynchronization','启用同步','',11,1,1.00,'','1','2022-08-08 17:37:35','','2022-08-01 14:38:57',''),
(7,NULL,1,'fieldConfiguration','/fieldConfiguration','/manage/fieldConfiguration','表单字段配置','',11,1,2.00,'','1','2022-08-05 17:30:53','','2022-08-01 14:39:54',''),
(8,NULL,1,'kingdeeLog','/kingdeeLog','/manage/kingdeeLog','金蝶日志','',11,1,3.00,'','1','2022-08-04 09:03:10','','2022-08-01 14:44:30',''),
(9,NULL,1,'thirdPartyLog','/thirdPartyLog','/manage/thirdPartyLog','第三方日志','',11,1,4.00,'','1','2022-08-08 09:30:42','','2022-08-01 14:45:50',''),
(11,NULL,0,'manage','/manage','Layout','集成管理','Tickets',0,0,0.00,'','1','2022-08-08 17:15:28','','2022-08-04 08:55:24',''),
(16,NULL,1,'synchronousMonitoring','/synchronousMonitoring','/manage/synchronousMonitoring','同步监控','',11,1,5.00,'','1','2022-08-08 17:37:44','','2022-08-08 17:37:24',''),
(19,NULL,1,'formConfiguration','/formConfiguration','/manage/formConfiguration','表单配置','',11,1,6.00,'','1','2022-10-10 11:39:38','','2022-10-10 11:39:38',''),
(21,NULL,1,'manage/stso','/manage/stso','/manage/stso','同步操作','',11,1,7.00,'','1','2022-11-12 16:38:24','','2022-11-12 16:38:24',''),
(22,NULL,1,'manage/platformProducts','/manage/platformProducts','/manage/platformProducts','平台产品','',11,1,8.00,'','1','2022-11-14 09:09:41','','2022-11-14 09:09:41','');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) NOT NULL,
  `role_Desc` varchar(64) NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`role_code`,`role_Name`,`role_Desc`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29','');

/*Table structure for table `sys_role_permission` */

DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`role_id`,`perm_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,1,'2022-08-01 09:52:02','','2022-08-01 09:52:02',''),
(2,1,2,'2022-08-01 09:52:03','','2022-08-01 09:52:03',''),
(3,1,3,'2022-08-01 09:52:05','','2022-08-01 09:52:05',''),
(4,1,4,'2022-08-01 09:52:06','','2022-08-01 09:52:06',''),
(6,1,6,'2022-08-01 14:40:37','','2022-08-01 14:40:37',''),
(7,1,7,'2022-08-01 14:40:37','','2022-08-01 14:40:37',''),
(8,1,8,'2022-08-01 14:46:00','','2022-08-01 14:46:00',''),
(21,1,11,'2022-08-06 16:38:22','','2022-08-06 16:38:22',''),
(22,1,9,'2022-08-06 16:38:29','','2022-08-06 16:38:29',''),
(23,1,16,'2022-08-08 17:37:53','','2022-08-08 17:37:53',''),
(26,1,19,'2022-10-10 11:39:48','','2022-10-10 11:39:48',''),
(28,1,21,'2022-11-12 16:38:33','','2022-11-12 16:38:33',''),
(29,1,22,'2022-11-14 09:09:50','','2022-11-14 09:09:50','');

/*Table structure for table `sys_sms` */

DROP TABLE IF EXISTS `sys_sms`;

CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms` */

/*Table structure for table `sys_sms_template` */

DROP TABLE IF EXISTS `sys_sms_template`;

CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms_template` */

insert  into `sys_sms_template`(`id`,`template_name`,`template_code`,`template_type`,`template_content`,`template_test_json`,`create_time`,`create_by`,`update_time`,`update_by`) values 
('1','系统消息通知','sys_ts_note','4','<h1>&nbsp; &nbsp; 系统通知</h1>\n<ul>\n<li>通知时间：&nbsp; ${ts_date}</li>\n<li>通知内容：&nbsp; ${ts_content}</li>\n</ul>',NULL,'2019-11-27 16:30:27','admin','2019-11-27 19:36:50','admin'),
('2','流程催办','bpm_cuiban','4','<h1>&nbsp; &nbsp;流程催办提醒</h1>\n<ul>\n<li>流程名称：&nbsp; ${bpm_name}</li>\n<li>催办任务：&nbsp; ${bpm_task}</li>\n<li>催办时间 :&nbsp; &nbsp; ${datetime}</li>\n<li>催办内容 :&nbsp; &nbsp; ${remark}</li>\n</ul>',NULL,'2019-11-27 17:08:12','admin','2019-11-27 19:36:45','admin'),
('3','流程办理超时提醒','bpm_chaoshi_tip','4','<h1>&nbsp; &nbsp;流程办理超时提醒</h1>\n<ul>\n<li>&nbsp; &nbsp;超时提醒信息：&nbsp; &nbsp; 您有待处理的超时任务，请尽快处理！</li>\n<li>&nbsp; &nbsp;超时任务标题：&nbsp; &nbsp; ${title}</li>\n<li>&nbsp; &nbsp;超时任务节点：&nbsp; &nbsp; ${task}</li>\n<li>&nbsp; &nbsp;任务处理人：&nbsp; &nbsp; &nbsp; &nbsp;${user}</li>\n<li>&nbsp; &nbsp;任务开始时间：&nbsp; &nbsp; ${time}</li>\n</ul>',NULL,'2019-11-27 19:19:24','admin','2019-11-27 19:36:37','admin'),
('4','请维护下商品单价','11111','4','<p>请帮忙维护下商品单价</p>',NULL,'2020-11-18 17:18:58','admin','2020-11-18 17:20:18','admin'),
('5','催办：${taskName}','SYS001','3','${userName}，您好！\r\n请前待办任务办理事项！${taskName}\r\n\r\n\r\n===========================\r\n此消息由系统发出','{\r\n\"taskName\":\"HR审批\",\r\n\"userName\":\"admin\"\r\n}','2018-07-05 14:46:18','admin','2018-07-05 18:31:34','admin');

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `realname` varchar(50) DEFAULT '' COMMENT '真名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int(11) DEFAULT '0',
  `account_Non_Expired` int(11) DEFAULT '0',
  `account_Non_Locked` int(11) DEFAULT '0',
  `credentials_Non_Expired` int(11) DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`username`,`realname`,`password`,`create_Date`,`last_Login_Time`,`enabled`,`account_Non_Expired`,`account_Non_Locked`,`credentials_Non_Expired`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','张三','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29','');

/*Table structure for table `sys_user_depart` */

DROP TABLE IF EXISTS `sys_user_depart`;

CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_user_depart` */

/*Table structure for table `sys_user_message` */

DROP TABLE IF EXISTS `sys_user_message`;

CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `sys_user_message` */

insert  into `sys_user_message`(`user_id`,`name`,`avatar`,`introduction`,`fauth_account`,`fenglish_name`,`fwork_no`,`fdept`,`fphone`,`fmail`,`fwork_addr`,`fposition`,`finduction_date`,`fstate`,`fdate`,`fcreator`) values 
(1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00','');

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,'2022-06-08 14:22:02','','2022-06-08 14:22:02','');

/*Table structure for table `undo_log` */

DROP TABLE IF EXISTS `undo_log`;

CREATE TABLE `undo_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` bigint NOT NULL,
  `xid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `context` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int NOT NULL,
  `log_created` datetime NOT NULL,
  `log_modified` datetime NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `undo_log` */

/*Table structure for table `tb_dict_item` */

DROP TABLE IF EXISTS `tb_dict_item`;

CREATE TABLE `tb_dict_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(128) NOT NULL COMMENT '字典名称',
  `type` varchar(128) NOT NULL COMMENT '类型',
  `code` varchar(128) NOT NULL COMMENT '字典项代码（用于参数传递和存储）',
  `desc` varchar(128) DEFAULT NULL COMMENT '说明',
  `sort_order` int(11) NOT NULL COMMENT '排序（正序排列）',
  `status` int(2) DEFAULT '0' COMMENT '状态（0：正常，-1：废弃，1：只读）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_type_code` (`type`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='字典表';

/*Data for the table `tb_dict_item` */

insert  into `tb_dict_item`(`id`,`title`,`type`,`code`,`desc`,`sort_order`,`status`,`create_time`,`update_time`) values 
(1,'金蝶','product','kingdee',NULL,1,0,'2022-11-01 15:19:45','2022-11-01 15:19:45'),
(2,'商城','product','mall',NULL,2,0,'2022-11-01 15:20:02','2022-11-01 15:20:02'),
(3,'机器人','product','robot',NULL,3,0,'2022-11-24 15:50:27','2022-11-24 15:50:27');

/*Table structure for table `tb_init_connect_param` */

DROP TABLE IF EXISTS `tb_init_connect_param`;

CREATE TABLE `tb_init_connect_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `k3_cloud_url` varchar(64) NOT NULL COMMENT '金蝶地址',
  `dbid` varchar(64) NOT NULL COMMENT '金蝶账套',
  `uid` varchar(64) NOT NULL COMMENT '用户名',
  `pwd` varchar(64) NOT NULL COMMENT '密码',
  `lang` int(11) NOT NULL COMMENT '端口',
  `is_auto_submit` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否提交审核',
  `third_party_url` varchar(128) NOT NULL COMMENT '第三方路径',
  `duration` int(11) DEFAULT '1' COMMENT '定时任务时长/分钟',
  `lic_cipher_text` varchar(255) DEFAULT NULL COMMENT 'Lic密文',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶配置表';

/*Data for the table `tb_init_connect_param` */

insert  into `tb_init_connect_param`(`id`,`k3_cloud_url`,`dbid`,`uid`,`pwd`,`lang`,`is_auto_submit`,`third_party_url`,`duration`,`lic_cipher_text`,`create_time`,`update_time`) values
(1,'http://kingdee.neura-robotics.cn/k3Cloud/','61b17150a10564','robot','robot',2052,1,'http://192.168.0.60:81/wx/api/save',1,NULL,'2022-11-25 11:30:21','2022-12-14 17:38:27');

/*Table structure for table `tb_kingdee_common_config` */

DROP TABLE IF EXISTS `tb_kingdee_common_config`;

CREATE TABLE `tb_kingdee_common_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int(11) NOT NULL COMMENT '平台产品关系id',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `doc_type` varchar(64) NOT NULL COMMENT '第三方标识',
  `name` varchar(64) NOT NULL COMMENT '日志名称',
  `direction` varchar(128) NOT NULL COMMENT '产品方向',
  `operation` tinyint(1) NOT NULL COMMENT '操作(1-查询 2-创建/更新 3-同步)',
  `encapsulation_format` tinyint(1) NOT NULL COMMENT '封装格式(1-全部 2-聚合)',
  `primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据主键字段',
  `entry_primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据分录主键',
  `mes_entry_name` varchar(64) DEFAULT NULL COMMENT 'MES分录标识',
  `entry_name` varchar(64) DEFAULT NULL COMMENT '分录标识',
  `fathers_form_id` varchar(64) DEFAULT NULL COMMENT '源单标识',
  `father_entry_name` varchar(64) DEFAULT NULL COMMENT '源单分录标识',
  `push_rule` varchar(64) DEFAULT NULL COMMENT '下推规则',
  `is_in_transaction` tinyint(1) DEFAULT '1' COMMENT '是否在事务中',
  `is_auto_perform` tinyint(1) DEFAULT '3' COMMENT '执行步骤（0-暂存，1-保存，2-提交，3-审核）',
  `plug_in_url` text COMMENT '插件地址',
  `custom_sql` text COMMENT '自定义Sql',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶通用配置表';

/*Data for the table `tb_kingdee_common_config` */

insert  into `tb_kingdee_common_config`(`id`,`platform_product_relation_id`,`s_form_id`,`doc_type`,`name`,`direction`,`operation`,`encapsulation_format`,`primary_key_field`,`entry_primary_key_field`,`mes_entry_name`,`entry_name`,`fathers_form_id`,`father_entry_name`,`push_rule`,`is_in_transaction`,`is_auto_perform`,`plug_in_url`,`custom_sql`,`create_time`,`update_time`) values 
(1,1,'STK_Inventory','INVENTORY','即时库存','机器人-金蝶',1,1,'FID',NULL,NULL,NULL,NULL,NULL,NULL,1,3,NULL,NULL,'2022-11-24 15:54:13','2022-11-24 16:56:29');

/*Table structure for table `tb_kingdee_field_mapping` */

DROP TABLE IF EXISTS `tb_kingdee_field_mapping`;

CREATE TABLE `tb_kingdee_field_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `kingdee_common_config_id` int(11) NOT NULL COMMENT '金蝶通用配置id',
  `kingdee_field` varchar(128) NOT NULL COMMENT '金蝶字段',
  `kingdee_field_name` varchar(128) NOT NULL COMMENT '金蝶字段名称',
  `field_type` varchar(128) NOT NULL COMMENT '字段类型',
  `retrieval_field` varchar(64) DEFAULT NULL COMMENT '检索字段',
  `is_entry_field` varchar(64) NOT NULL COMMENT '是否是分录字段',
  `third_party_field` varchar(128) NOT NULL COMMENT '第三方字段',
  `third_party_field_name` varchar(128) NOT NULL COMMENT '第三方字段名称',
  `sort_order` int(11) NOT NULL COMMENT '排序顺序',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶字段映射表';

/*Data for the table `tb_kingdee_field_mapping` */

insert  into `tb_kingdee_field_mapping`(`id`,`kingdee_common_config_id`,`kingdee_field`,`kingdee_field_name`,`field_type`,`retrieval_field`,`is_entry_field`,`third_party_field`,`third_party_field_name`,`sort_order`,`create_time`,`update_time`) values 
(1,1,'FStockOrgId','组织编码','基础资料','FNumber','false','org_id','组织编码',1,'2022-11-24 16:01:24','2022-11-24 16:01:26'),
(2,1,'FStockOrgId','组织名称','基础资料','FName','false','org_name','组织名称',2,'2022-11-24 16:03:20','2022-11-24 16:03:48'),
(3,1,'FMaterialId','物料编码','基础资料','FNumber','false','mtrl_code','物料编码',3,'2022-11-24 16:03:57','2022-11-24 16:19:07'),
(4,1,'FMaterialId','物料名称','基础资料','FName','false','mtrl_name','物料名称',4,'2022-11-24 16:05:10','2022-11-24 16:19:49'),
(5,1,'FAuxPropId','辅助属性','文本','','false','prop_id','辅助属性',5,'2022-11-24 16:08:32','2022-11-24 16:08:32'),
(6,1,'FStockId','仓库编码','基础资料','FNumber','false','stock_code','仓库编码',6,'2022-11-24 16:09:38','2022-11-24 16:18:53'),
(7,1,'FStockId','仓库名称','基础资料','FName','false','stock_name','仓库名称',7,'2022-11-24 16:10:27','2022-11-24 16:19:01'),
(8,1,'FProduceDate','生产日期','文本','','false','produce_date','生产日期',8,'2022-11-24 16:11:23','2022-11-24 16:11:23'),
(9,1,'FKFPeriod','保质期','文本','','false','period','保质期',9,'2022-11-24 16:12:13','2022-11-24 16:12:13'),
(10,1,'FKFPeriodUnit','保质期单位','文本','','false','period_unit','保质期单位',10,'2022-11-24 16:13:06','2022-11-24 16:33:00'),
(11,1,'FLot','批次号','基础资料','FNumber','false','lot','批次号',11,'2022-11-24 16:14:29','2022-11-24 16:14:29'),
(12,1,'FBaseQty','库存量','数值','','false','qty','库存量',12,'2022-11-24 16:15:23','2022-11-24 16:15:23'),
(13,1,'FAVBQty','可用量','数值','','false','f_qty','可用量',13,'2022-11-24 16:16:17','2022-11-24 16:16:17'),
(14,1,'FStockUnitId','库存单位','基础资料','FNumber','false','unit','库存单位',14,'2022-11-24 16:18:28','2022-11-24 16:18:30');

/*Table structure for table `tb_platform_product_relation` */

DROP TABLE IF EXISTS `tb_platform_product_relation`;

CREATE TABLE `tb_platform_product_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `product_before_code` varchar(64) NOT NULL COMMENT '产品前编码',
  `product_after_code` varchar(64) NOT NULL COMMENT '产品后编码',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='平台产品关系表';

/*Data for the table `tb_platform_product_relation` */

insert  into `tb_platform_product_relation`(`id`,`product_before_code`,`product_after_code`,`create_time`,`update_time`) values 
(1,'kingdee','robot','2022-11-24 15:50:13','2022-11-24 15:50:13');

/*Table structure for table `tb_product_log` */

DROP TABLE IF EXISTS `tb_product_log`;

CREATE TABLE `tb_product_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int(11) NOT NULL COMMENT '平台产品关系id',
  `queue_id` varchar(128) NOT NULL COMMENT '唯一标识',
  `name` varchar(128) NOT NULL COMMENT '业务名称',
  `code` varchar(128) NOT NULL COMMENT '业务标识',
  `direction` varchar(128) NOT NULL COMMENT '方向',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `cost_time` int(11) DEFAULT '0' COMMENT '耗时（毫秒）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_queue_id` (`queue_id`),
  KEY `index_name` (`name`),
  KEY `index_code` (`code`),
  KEY `index_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='产品日志';

/*Data for the table `tb_product_log` */

/*Table structure for table `tb_quartz_job` */

DROP TABLE IF EXISTS `tb_quartz_job`;

CREATE TABLE `tb_quartz_job` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `job_class_name` varchar(255) DEFAULT NULL COMMENT '任务类名',
  `cron_expression` varchar(255) DEFAULT NULL COMMENT 'cron表达式',
  `parameter` varchar(255) DEFAULT NULL COMMENT '参数',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态（0-关闭 1-启动）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='定时任务表';

/*Data for the table `tb_quartz_job` */

insert  into `tb_quartz_job`(`id`,`job_class_name`,`cron_expression`,`parameter`,`description`,`status`,`create_time`,`update_time`) values 
(1,'com.system.quartz.job.KingDeeSynchronizationJob','0 */1  * * * ?','','金蝶同步定时任务',0,'2022-07-19 11:05:44','2022-11-09 16:36:55');

/*Table structure for table `tb_synchronization_record` */

DROP TABLE IF EXISTS `tb_synchronization_record`;

CREATE TABLE `tb_synchronization_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `queue_id` varchar(128) DEFAULT NULL COMMENT '唯一标识',
  `message` longtext COMMENT '错误原因',
  `status` tinyint(1) DEFAULT '0' COMMENT '同步状态（0-未同步，1-同步中，2-同步失败，3-同步成功）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`),
  KEY `index_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶同步记录表';

/*Data for the table `tb_synchronization_record` */

/*Table structure for table `tb_synchronization_record_temp` */

DROP TABLE IF EXISTS `tb_synchronization_record_temp`;

CREATE TABLE `tb_synchronization_record_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶同步记录临时表';

/*Data for the table `tb_synchronization_record_temp` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
