package com.system.model;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/**
 * @author Inori
 */
public class DelayedElement implements Delayed {

    private long mills;

    public DelayedElement(Integer min) {
        this.mills = System.currentTimeMillis() / 1000 + (60 * min);
    }

    /**
     * 当方法返回小于或等于0的数值时， 元素将会被消耗
     */
    @Override
    public long getDelay(TimeUnit unit) {
        return mills - (System.currentTimeMillis() / 1000);
    }

    /**
     * DelayQueue底层是优先队列，需要实现compareTo方法，
     * 用于在入列的时候与容器中的数据进行比较，以便确定元素位置。
     */
    @Override
    public int compareTo(Delayed o) {
        return (int) (mills - ((DelayedElement) o).getMills());
    }

    public long getMills() {
        return mills;
    }

    public void setMills(long mills) {
        this.mills = mills;
    }


}
