package com.system.transfer.kingdee;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

//@Data
public class KingDeeFilterStringVo {
    private String fieldName;
    private String compare;
    private String value;

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getCompare() {
        if (StringUtils.isEmpty(this.compare)) {
            this.compare = "like";
        }
        return compare;
    }

    public void setCompare(String compare) {
        if (StringUtils.isEmpty(compare)) {
            this.compare = "like";
        } else {
            this.compare = compare;
        }

    }

    public String getValue() {
        if ("like".equals(this.compare)) {
            if (!this.value.startsWith("%")) {
                this.value = "%" + this.value;
            }
            if (!this.value.endsWith("%")) {
                this.value = this.value + "%";
            }
        }
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
